/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.restore.handlers;

import java.util.Map;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.state.DockingState;
import org.flexdock.perspective.PerspectiveManager;
import org.flexdock.perspective.restore.handlers.RestorationHandler;
import org.flexdock.util.DockingUtility;

public class RelativeHandler
implements RestorationHandler {
    public boolean restore(Dockable dockable, DockingState dockingState, Map context) {
        Dockable parent;
        Dockable dockable2 = parent = dockingState == null ? null : dockingState.getRelativeParent();
        if (!DockingManager.isDocked(parent)) {
            return false;
        }
        DockingState parentDockingState = PerspectiveManager.getInstance().getDockingState(parent);
        if (parentDockingState == null || parentDockingState.isFloating() || parentDockingState.isMinimized()) {
            return false;
        }
        float splitRatio = dockingState.getSplitRatio();
        String dockingRegion = dockingState.getRegion();
        boolean dockingOperationResult = DockingUtility.dockRelative(dockable, parent, dockingRegion, splitRatio);
        if (dockingOperationResult) {
            DockingUtility.setSplitProportion(dockable, splitRatio);
        }
        return dockingOperationResult;
    }
}

