/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdnc;

import java.awt.Dimension;
import java.net.URL;
import javax.swing.JScrollPane;
import org.jdesktop.jdnc.JNComponent;
import org.jdesktop.swing.Application;
import org.jdesktop.swing.JXEditorPane;

public class JNEditor
extends JNComponent {
    private JXEditorPane editor = new JXEditorPane("text/html", "");
    private String inputURL;
    private boolean readonly;
    private static final String DEFAULT_TYPE = "text/plain";
    private String type = "text/plain";
    private static final Dimension MAX_SIZE = new Dimension(400, 300);

    public JNEditor() {
        this.setComponent(this.editor);
        this.add(new JScrollPane(this.editor));
    }

    public JXEditorPane getEditor() {
        return this.editor;
    }

    public void setReadOnly(boolean ro) {
        this.readonly = ro;
        this.editor.setEditable(!this.readonly);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setInputURL(String inputURL) {
        URL url;
        if (this.editor != null && inputURL != null && (url = Application.getURL(inputURL, this)) != null) {
            this.setInputURL(url);
        }
    }

    public void setInputURL(URL url) {
        if (this.editor != null && url != null) {
            this.inputURL = url.toString();
            try {
                this.editor.setPage(url);
            }
            catch (Exception ex) {
                System.out.println("Error Setting page url: " + url);
                ex.printStackTrace();
            }
        }
    }

    public String getInputURL() {
        return this.inputURL;
    }

    public void setDocumentType(String type) {
        if (!"text/html".equals(type)) {
            type = DEFAULT_TYPE;
        }
        if (type == null || "".equals(type)) {
            type = DEFAULT_TYPE;
        }
        this.type = type;
        this.editor.setContentType(type);
    }

    public String getDocumentType() {
        return this.type;
    }

    public Dimension getPreferredSize() {
        return MAX_SIZE;
    }
}

