/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.binding;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.jdesktop.swing.binding.AbstractBinding;
import org.jdesktop.swing.data.DataModel;

public class BooleanBinding
extends AbstractBinding {
    private JComponent component;
    private ButtonModel buttonModel;

    public BooleanBinding(JToggleButton toggleButton, DataModel dataModel, String fieldName) {
        super(toggleButton, dataModel, fieldName, 2);
        this.initModel(toggleButton.getModel());
    }

    public BooleanBinding(JComponent component, ButtonModel buttonModel, DataModel dataModel, String fieldName) {
        super(component, dataModel, fieldName, 2);
        this.initModel(buttonModel);
    }

    public JComponent getComponent() {
        return this.component;
    }

    protected void setComponent(JComponent component) {
        this.component = component;
    }

    protected Object getComponentValue() {
        return this.buttonModel.isSelected();
    }

    protected void setComponentValue(Object value) {
        if (value != null) {
            this.buttonModel.setSelected((Boolean)value);
        } else {
            this.buttonModel.setSelected(false);
        }
    }

    private void initModel(ButtonModel model) {
        this.buttonModel = model;
        this.buttonModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!BooleanBinding.this.pulling) {
                    BooleanBinding.this.setModified(true);
                }
            }
        });
    }
}

