/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.data;

import java.util.Locale;
import org.jdesktop.swing.data.MetaData;
import org.jdesktop.swing.data.Validator;

public class NumberMetaData
extends MetaData {
    protected Number minimum = null;
    protected Number maximum = null;
    protected boolean currency = false;
    private Validator rangeValidator = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public NumberMetaData() {
        this("numbervalue");
    }

    public NumberMetaData(String name) {
        super(name);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.klass = clazz;
    }

    public NumberMetaData(String name, Class klass) {
        this(name);
        this.klass = klass;
    }

    public NumberMetaData(String name, Class klass, String label) {
        this(name, klass);
        this.label = label;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Number minimum) {
        if (this.klass != minimum.getClass()) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": minimum value is class " + minimum.getClass().getName() + " but should be " + this.getClass().getName());
        }
        Number oldMinimum = this.minimum;
        this.minimum = minimum;
        this.setupRangeValidator();
        this.firePropertyChange("minimum", oldMinimum, minimum);
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Number maximum) {
        if (this.getElementClass() != maximum.getClass()) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + ": maximum value is class " + maximum.getClass().getName() + " but should be " + this.getClass().getName());
        }
        Number oldMaximum = this.maximum;
        this.maximum = maximum;
        this.setupRangeValidator();
        this.firePropertyChange("maximum", oldMaximum, maximum);
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public void setCurrency(boolean currency) {
        boolean oldCurrency = this.currency;
        this.currency = currency;
        this.firePropertyChange("currency", oldCurrency, currency);
    }

    private void setupRangeValidator() {
        if (this.maximum != null || this.minimum != null) {
            if (this.rangeValidator == null) {
                this.rangeValidator = this.getRangeValidator();
                this.addValidator(this.rangeValidator);
            }
        } else if (this.rangeValidator != null) {
            this.removeValidator(this.rangeValidator);
            this.rangeValidator = null;
        }
    }

    private Validator getRangeValidator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.klass.equals(clazz)) {
            return new IntegerRangeValidator();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.klass.equals(clazz2)) {
            return new LongRangeValidator();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.klass.equals(clazz3)) {
            return new FloatRangeValidator();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.klass.equals(clazz4)) {
            return new ShortRangeValidator();
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.klass.equals(clazz5)) {
            return new DoubleRangeValidator();
        }
        return null;
    }

    private class IntegerRangeValidator
    implements Validator {
        private IntegerRangeValidator() {
        }

        public boolean validate(Object value, Locale locale, String[] error) {
            int intValue = (Integer)value;
            if (NumberMetaData.this.maximum != null && intValue > (Integer)NumberMetaData.this.maximum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + intValue + " exceeds maximum " + (Integer)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && intValue < (Integer)NumberMetaData.this.minimum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + intValue + " is less than the minimum" + (Integer)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }

    private class LongRangeValidator
    implements Validator {
        private LongRangeValidator() {
        }

        public boolean validate(Object value, Locale locale, String[] error) {
            long longValue = (Long)value;
            if (NumberMetaData.this.maximum != null && longValue > (Long)NumberMetaData.this.maximum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + longValue + " exceeds maximum " + (Long)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && longValue < (Long)NumberMetaData.this.minimum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + longValue + " is less than the minimum" + (Long)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }

    private class ShortRangeValidator
    implements Validator {
        private ShortRangeValidator() {
        }

        public boolean validate(Object value, Locale locale, String[] error) {
            short shortValue = (Short)value;
            if (NumberMetaData.this.maximum != null && shortValue > (Short)NumberMetaData.this.maximum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + shortValue + " exceeds maximum " + (Short)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && shortValue < (Short)NumberMetaData.this.minimum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + shortValue + " is less than the minimum" + (Short)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }

    private class FloatRangeValidator
    implements Validator {
        private FloatRangeValidator() {
        }

        public boolean validate(Object value, Locale locale, String[] error) {
            float floatValue = ((Float)value).floatValue();
            if (NumberMetaData.this.maximum != null && floatValue > ((Float)NumberMetaData.this.maximum).floatValue()) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + floatValue + " exceeds maximum " + ((Float)NumberMetaData.this.maximum).floatValue();
                return false;
            }
            if (NumberMetaData.this.minimum != null && floatValue < ((Float)NumberMetaData.this.minimum).floatValue()) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + floatValue + " is less than the minimum" + ((Float)NumberMetaData.this.minimum).floatValue();
                return false;
            }
            return true;
        }
    }

    private class DoubleRangeValidator
    implements Validator {
        private DoubleRangeValidator() {
        }

        public boolean validate(Object value, Locale locale, String[] error) {
            double doubleValue = (Double)value;
            if (NumberMetaData.this.maximum != null && doubleValue > (Double)NumberMetaData.this.maximum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + doubleValue + " exceeds maximum " + (Double)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && doubleValue < (Double)NumberMetaData.this.minimum) {
                error[0] = String.valueOf(NumberMetaData.this.getName()) + ": value " + doubleValue + " is less than the minimum" + (Double)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }
}

