/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swing.decorator.ComponentAdapter;

public class Highlighter {
    int order = -1;
    public static final Highlighter ledgerBackground = new Highlighter(new Color(245, 255, 245), null);
    public static final Highlighter notePadBackground = new Highlighter(new Color(255, 255, 204), null);
    private Color background = null;
    private Color foreground = null;
    private Color selectedBackground = null;
    private Color selectedForeground = null;

    public Highlighter() {
    }

    public Highlighter(Color cellBackground, Color cellForeground) {
        this.background = cellBackground;
        this.foreground = cellForeground;
    }

    public Component highlight(Component renderer, ComponentAdapter adapter) {
        return this.doHighlight(renderer, adapter);
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        this.applyBackground(renderer, adapter);
        this.applyForeground(renderer, adapter);
        this.applyFont(renderer, adapter);
        return renderer;
    }

    protected void applyBackground(Component renderer, ComponentAdapter adapter) {
        Color color = this.computeBackground(renderer, adapter);
        if (color != null) {
            renderer.setBackground(color);
        }
    }

    protected void applyForeground(Component renderer, ComponentAdapter adapter) {
        Color color = this.computeForeground(renderer, adapter);
        if (color != null) {
            renderer.setForeground(color);
        }
    }

    protected void applyFont(Component renderer, ComponentAdapter adapter) {
    }

    protected Color computeBackground(Component renderer, ComponentAdapter adapter) {
        Color seed = this.background == null ? adapter.target.getBackground() : this.background;
        return adapter.isSelected() ? this.computeSelectedBackground(seed) : seed;
    }

    protected Color computeForeground(Component renderer, ComponentAdapter adapter) {
        Color seed = this.foreground == null ? adapter.target.getForeground() : this.foreground;
        return adapter.isSelected() ? this.computeSelectedForeground(seed) : seed;
    }

    protected Color computeSelectedBackground(Color seed) {
        return this.selectedBackground == null ? (seed == null ? Color.gray : seed.darker()) : this.selectedBackground;
    }

    protected Color computeSelectedForeground(Color seed) {
        return this.selectedForeground == null ? Color.white : this.selectedForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        this.selectedBackground = color;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        this.selectedForeground = color;
    }
}

