package net.sourceforge.ganttproject.datafilter;

import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskMutator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * Quick fix option - reschedule for tomorrow. 
 * 
 * Created 26.02.2008
 * 
 * @author Joanna Muras 
 */
public class AutoFixRescheduleForNextDay implements AutoFix {

    Task myTask;
    
    public AutoFixRescheduleForNextDay(Task task) {
        myTask = task;
    }
    
    public String getDescription() {
        return GanttLanguage.getInstance().getText("datefilter.autofix.rescheduleForTomorrow");
    }

    public Task getTask() {
        return myTask;
    }

    public IStatus run() {
        /* Add one day to the task end date */
        GanttCalendar endDate = myTask.getEnd();
        endDate.add(1);
        /* Get task mutator */
        TaskMutator mutator = myTask.createMutator();
        /* Set new end date and commit changes */
        mutator.setEnd(endDate);
        mutator.commit();
        return Status.OK_STATUS;
    }
}
