/**
 * Common methods for state of export wizard.
 * 
 * Created 12.04.2008
 * 
 * @author Joanna Muras 
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import java.util.Collections;
import java.util.List;

import net.sourceforge.ganttproject.gui.options.model.BooleanOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultBooleanOption;

public abstract class State {

    protected Exporter myExporter;
    protected File myFile;
    protected List myTaskContext = Collections.EMPTY_LIST;
    private final BooleanOption myPublishInWebOption = new DefaultBooleanOption("exporter.publishInWeb");

    public abstract  void setFile(File file);
    public abstract void setExporter(Exporter exporter);

    public File getFile() {
        return myFile;
    }

    public Exporter getExporter() {
        return myExporter;
    }

    public void setTaskContext(List selectedTasks) {
        myTaskContext = selectedTasks;
    }

    public List getTaskContext() {
        return myTaskContext;
    }

    public BooleanOption getPublishInWebOption() {
        return myPublishInWebOption;
    }
}
