package net.sourceforge.ganttproject.gui.options.model;

public class DefaultBooleanOption extends GPAbstractOption implements
        BooleanOption {

    private boolean myValue;

    private boolean myLockedValue;

    public DefaultBooleanOption(String id) {
        this(id,false);
    }
    public DefaultBooleanOption(String id, boolean isChecked) {
        super(id);
        myValue = isChecked;
    }
    
    public boolean isChecked() {
        return isLocked() ? myLockedValue : myValue;
    }

    public void toggle() {
        ChangeValueEvent event = new ChangeValueEvent(getID(), Boolean.valueOf(myLockedValue), Boolean.valueOf(!myLockedValue));
        if (isLocked()) {
            myLockedValue = !myLockedValue;
        }
        else {
           myValue = !myValue;
        }
        fireChangeValueEvent(event);
    }

    protected void setValue(boolean value) {
        if (value != myLockedValue) {
            toggle();
        }
    }
    public void lock() {
        super.lock();
        myLockedValue = myValue;
    }

    public void commit() {
        super.commit();
        myValue = myLockedValue;
    }

    public String getPersistentValue() {
        return Boolean.toString(isChecked());
}
    public void loadPersistentValue(String value) {
        myLockedValue = Boolean.valueOf(value).booleanValue();
    }

    public boolean isChanged() {
        if (isLocked()) {
            return myValue!=myLockedValue;
        }
        return false;
    }    
    
}
