package net.sourceforge.ganttproject.print;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.plugins.PluginManager;

class GPPrintServiceStub implements GPPrintService {
    
    public void print(IGanttProject project, Chart chart, UIFacade uifacade) {
        GPPrintService[] extensions = (GPPrintService[])PluginManager.getExtensions(
                GPPrintService.EXTENSION_POINT_ID, GPPrintService.class);
        if (extensions.length==0) {
            uifacade.showInformationDialog(i18n("printing.info.noPrintingService"));
        } else {
            extensions[0].showPreview(project, chart, uifacade);
        }
    }

    private String i18n(String key) {
        return GanttLanguage.getInstance().getText(key);
    }

    public void showPreview(IGanttProject project, Chart chart, UIFacade uifacade) {
        GPPrintService[] extensions = (GPPrintService[])PluginManager.getExtensions(
                GPPrintService.EXTENSION_POINT_ID, GPPrintService.class);
        if (extensions.length==0) {
            uifacade.showInformationDialog(i18n("printing.info.noPrintingService"));
        } else {
            extensions[0].showPreview(project, chart, uifacade);
        }
    }

    public IStatus checkPrintingAvailability() {
        GPPrintService[] extensions = (GPPrintService[])PluginManager.getExtensions(
                GPPrintService.EXTENSION_POINT_ID, GPPrintService.class);
        return extensions.length==0 ? Status.OK_STATUS : extensions[0].checkPrintingAvailability();
    }

}
