/*
 * Created on 09.11.2004
 */
package net.sourceforge.ganttproject.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * @author bard
 */
public interface TimeUnitStack {
    TimeUnit getDefaultTimeUnit();

    TimeFrame createTimeFrame(Date startDate, TimeUnit topUnit,
            TimeUnit bottomUnit);

    TimeUnitPair[] getTimeUnitPairs();

    String getName();

    List<TimeUnit> getTimeUnits();

    void setTimeUnitRange(TimeUnit minimalTimeUnit, TimeUnit maximalTimeUnit);
    void addTimeUnitStackListener(Listener listener);
    void removeTimeUnitStackListener(Listener listener);
    interface Listener {
        void timeUnitStackChanged();
    }
    TimeUnit findTimeUnit(String code);
    String encode(TimeUnit timeUnit);

    DateFormat[] getDateFormats();
    DateFormat getTimeFormat();
}
