package net.sourceforge.ganttproject.time.gregorian;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;

import net.sourceforge.ganttproject.time.TextFormatter;
import net.sourceforge.ganttproject.time.TimeUnitText;

public class HourTextFormatter extends CachingTextFormatter implements TextFormatter {

    protected TimeUnitText createTimeUnitText(Date adjustedLeft) {
        getCalendar().setTime(adjustedLeft);
        return new TimeUnitText(MessageFormat.format("{0}h", new Object[] {
                new Integer(getCalendar().get(Calendar.HOUR_OF_DAY))
        }));
    }

}
