/*
 * Created on 26.09.2005
 */
package org.ganttproject.impex.htmlpdf;

import java.net.URL;

import net.sourceforge.ganttproject.export.Stylesheet;

class StylesheetImpl implements Stylesheet {
    private String myLocalizedName;
    private final URL myURL;
    private StylesheetType myStylesheetType;

    StylesheetImpl(URL stylesheetURL, String localizedName, StylesheetType stylesheetType) {
        assert stylesheetURL!=null;
        myURL = stylesheetURL;
        myLocalizedName = localizedName;
        myStylesheetType = stylesheetType;
    }
    public String getLocalizedName() {
        return myLocalizedName;
    }

    public StylesheetType getStylesheetType() {
        return myStylesheetType;
    }

    @Override
    public String toString() {
        return getLocalizedName();
    }

    public URL getUrl() {
        return myURL;
    }
}