/*
 * This code is provided under the terms of GPL version 2.
 * Please see LICENSE file for details
 * (C) Dmitry Barashev, GanttProject team, 2004-2008
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Color;
import java.util.List;

import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;

/**
 * Renders horizontal lines that separate tasks in the gantt chart
 */
class TaskGridRendererImpl extends ChartRendererBase  {
    private ChartModelImpl myModel;

    TaskGridRendererImpl(ChartModelImpl model) {
        super(model);
        myModel = model;
    }

    public void render() {
        getPrimitiveContainer().setOffset(0, myModel.getChartUIConfiguration().getHeaderHeight()-myModel.getVerticalOffset());
        getPrimitiveContainer().clear();
        int rowHeight = getConfig().getRowHeight();
        int ypos = rowHeight;
        List<Task> tasks = ((ChartModelImpl) getChartModel()).getVisibleTasks();
        if (tasks==null) {
            return;
        }
        for (int i = 0; i < tasks.size(); i++) {
            GraphicPrimitiveContainer.Line nextLine = 
                getPrimitiveContainer().createLine(
                        0, ypos,
                        (int) getChartModel().getBounds().getWidth(), ypos);
            nextLine.setForegroundColor(Color.GRAY);
            ypos += rowHeight;
        }
    }

    protected int getHeight() {
        return (int) getChartModel().getBounds().getHeight()
                - getConfig().getHeaderHeight();
    }

}
