package net.sourceforge.ganttproject.datafilter;

import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskMutator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * Quick fix option - reschedule for tomorrow. 
 * 
 * Created 26.02.2008
 * 
 * @author Joanna Muras 
 */
public class AutoFixCompleted implements AutoFix {

    Task myTask;
    
    public AutoFixCompleted(Task task) {
        myTask = task;
    }
    
    public String getDescription() {
        return GanttLanguage.getInstance().getText("datefilter.autofix.completed");
    }

    public Task getTask() {
        return myTask;
    }

    public IStatus run() {
        /* Get task mutator */
        TaskMutator mutator = myTask.createMutator();
        /* Set task as completed and commit changes */
        mutator.setCompletionPercentage(100);
        mutator.commit();
        return Status.OK_STATUS;
    }
}
