/**
 * Action to invoke export filter wizard.
 * 
 * Created 12.04.2008
 * 
 * @author Joanna Muras 
 */
package net.sourceforge.ganttproject.datafilter;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.datafilter.task.FilteredTasks;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.task.Task;

public class ExportFilterAction extends GPAction {

    private final UIFacade myUIFacade;
    private final IGanttProject myProject;
    private TaskGroup[] myTaskGroups;

    public ExportFilterAction(UIFacade uifacade, IGanttProject project) {
        super(null, "16");
        myUIFacade = uifacade;
        myProject =  project;
    }

    public void actionPerformed(ActionEvent arg0) {
        List<Task> tasks = new ArrayList<Task>();
        for (TaskGroup taskGroup: myTaskGroups) {
            tasks.addAll(Arrays.asList(taskGroup.getTasks()));
        }

        ExportFilterWizard exportFilterWizard = new ExportFilterWizard(myUIFacade, myProject, ((GanttProject)myProject).getOptions(), tasks);
        exportFilterWizard.show();
    }

    protected String getLocalizedName() {
        return getI18n("datafilter.exportFilter");
    }

    protected String getIconFilePrefix() {
        return null;
    }

    public void setFilter(FilteredTasks mySelectedFilter) {
        myTaskGroups = mySelectedFilter.getTaskGroups();
        if (myTaskGroups == null || myTaskGroups.length==0) {
            setEnabled(false);
        }
        else {
            setEnabled(true);
        }
        
    }
}
