package net.sourceforge.ganttproject.datafilter;

import java.util.EventObject;

import net.sourceforge.ganttproject.datafilter.task.FilteredTasks;


/**
 * Event generated on task addition, removal, or properties change. 
 * 
 * Created 12.2007
 * 
 * @author Joanna Muras 
 */
public class FilteringEvent extends EventObject {
    
    private TaskGroup[] myTaskGroups;
    
    public FilteringEvent(Object source, TaskGroup[] taskGroups) {
        super(source);
        myTaskGroups = taskGroups;
    }
    
    public TaskGroup[] getTaskGroups() {
        return myTaskGroups;
    }
    
    public FilteredTasks getTasks() {
        return (FilteredTasks)source;
    }
}
