package net.sourceforge.ganttproject.datafilter;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;

/**
 * This class includes common functions for all filter classes that implements TaskGroup.
 * 
 * Created 12.2007
 * 
 * @author Joanna Muras 
 */
public abstract class TaskGroupBase implements TaskGroup {

    /** Group name */
    private String myName;
    /** Tasks in a group */
    private Task[] myTasks;
    private final TaskManager myTaskManager;

    public TaskGroupBase(String name, TaskManager taskManager) {
        myName = name;
        myTaskManager = taskManager;
    }

    public String getName() {
        return myName;
    }

    public Task[] getTasks() {
        return myTasks;
    }

    /**
     * This function fills taskList with all the tasks
     * @param parent task
     * @param list of all the tasks
     */
    private void getAllTasks(Task parent, List<Task> taskList) {
        Task[] tasks = myTaskManager.getTaskHierarchy().getNestedTasks(parent);
        for (Task task: tasks) {
            taskList.add(task);
            getAllTasks(task, taskList);
        }
    }

    protected TaskManager getTaskManager() {
        return myTaskManager;
    }

    public void filterTasks() {
        List<Task> unfiltered = new ArrayList<Task>();
        getAllTasks(myTaskManager.getTaskHierarchy().getRootTask(), unfiltered);
        List<Task> filtered = new ArrayList<Task>();
        filterTasks(unfiltered, filtered);
        myTasks = new Task[filtered.size()];
        filtered.toArray(myTasks);        
    }
    protected abstract void filterTasks(List<Task> unfiltered, List<Task> filtered); 
}
