package net.sourceforge.ganttproject.datafilter.task;

import java.util.List;

import net.sourceforge.ganttproject.datafilter.TaskGroupBase;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;

/**
 * Implementation of TaskGroup interface. Filter existing tasks according to Priority.
 * 
 * Created 12.2007
 * 
 * @author Joanna Muras 
 */
public class PriorityTaskGroup extends TaskGroupBase {

    public PriorityTaskGroup(String name, TaskManager taskManager) {
        super(name, taskManager);
    }

    /**
     * Filter existing tasks according to the groups and save them as myTasks variable.
     */
    protected void filterTasks(List<Task> unfiltered, List<Task> filtered) {

        for (Task task : unfiltered) {
            if ( includeTaskAccordingToPriority(task.getPriority(), task.getCompletionPercentage()) ) {
                filtered.add(task); 
            }
        }
    }

    /**
     * Check to which priority group task should be added
     * @param taskPriority
     * @param if you want taskCompletion not to be check give taskCompletion<100
     * @return true if right priority group
     */
    private boolean includeTaskAccordingToPriority(int taskPriority, int taskCompletion) {

        /* Set values for priorities */
        int high = 0;
        int normal = 1;
        int low = 2;

        /* If group name equals high and task priority is high */
        if (getName().equals("high") && taskPriority==high && taskCompletion<100) {
            return true;
            /* If group name equals normal and task priority is normal */
        } else if (getName().equals("medium") && taskPriority==normal && taskCompletion<100) {
            return true;
            /* If group name equals low and task priority is low */
        } else if (getName().equals("low") && taskPriority==low && taskCompletion<100) {
            return true;
        }
        return false;
    }
}
