package net.sourceforge.ganttproject.gui;

import javax.swing.JComponent;

import net.sourceforge.ganttproject.gui.options.model.ColorOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.taskproperties.IPropertySheetComponent;
import net.sourceforge.ganttproject.language.GanttLanguage;

public interface IPropertySheetBuilder {
    JComponent buildPlanePage(GPOptionGroup optionGroup);
    JComponent buildPlanePage(GPOptionGroup[] optionGroups);
    JComponent buildPropertySheets(IPropertySheetComponent[] components);
    public static class I18N {
        private String myOptionKeyPrefix = "option.";
        private String myOptionGroupKeyPrefix = "optionGroup.";
        private String myOptionPageKeyPrefix = "optionPage.";
        
        public I18N() {
        }
        
        protected String getValue(String key) {
            return GanttLanguage.getInstance().getText(key);
        }
        public String getPageTitle(String pageID) {
            return GanttLanguage.getInstance().getText(
                    myOptionPageKeyPrefix + pageID + ".title");
        }

        public String getPageDescription(String pageID) {
            return GanttLanguage.getInstance().getText(
                    myOptionPageKeyPrefix + pageID + ".description");
        }

        public String getOptionGroupLabel(GPOptionGroup group) {
            return GanttLanguage.getInstance().getText(
                    myOptionGroupKeyPrefix + group.getID() + ".label");
        }

        public String getOptionLabel(GPOption option) {
            return GanttLanguage.getInstance().getText(
                    myOptionKeyPrefix + option.getID() + ".label");
        }

        public String getAdvancedActionTitle() {
            return GanttLanguage.getInstance().getText("optionAdvanced.label");
        }
        
        public String getColorButtonText(ColorOption colorOption) {
            return GanttLanguage.getInstance().getText("colorButton");
        }
        
        public String getColorChooserTitle(ColorOption colorOption) {
            return GanttLanguage.getInstance().getText("selectColor");
        }

        public void setOptionKeyPrefix(String optionKeyPrefix) {
            myOptionGroupKeyPrefix = optionKeyPrefix;
        }
    }
    
}
