package net.sourceforge.ganttproject.gui.options.model;

public class DefaultIntegerOption extends GPAbstractOption implements IntegerOption {

    private int myInitialValue;
    private int myEditValue;

    public DefaultIntegerOption(String id) {
        this(id, 0);
    }
    
    public DefaultIntegerOption(String id, int initialValue) {
        super(id);
        myInitialValue = initialValue;
        myEditValue = initialValue;
    }

    public void editValue(int value) {
        ChangeValueEvent event = null;
        if (value!=myEditValue) {
            event = new ChangeValueEvent(
                    getID(), String.valueOf(myEditValue), String.valueOf(value));
        }
        myEditValue = value;
        if (event!=null) {
            fireChangeValueEvent(event);
        }
    }

    public void reloadValue(int value) {
        ChangeValueEvent event = null;
        if (value!=myEditValue) {
            event = new ChangeValueEvent(
                    getID(), String.valueOf(myEditValue), String.valueOf(value));
        }
        myInitialValue = value;
        myEditValue = value;
        if (event!=null) {
            fireChangeValueEvent(event);
        }
    }
    
    public int getEditValue() {
        return myInitialValue;
    }

    public int getValue() {
        return myInitialValue;
    }

    public void commit() {
        myInitialValue = myEditValue;
    }

    public void rollback() {
        reloadValue(myInitialValue);
    }
    
    public String getPersistentValue() {
        int value = getValue();
        return String.valueOf(value);
    }

    public void loadPersistentValue(String value) {
        int intValue = Integer.parseInt(value);
        reloadValue(intValue);
    }

    public boolean isChanged() {
        return myEditValue!=myInitialValue;
    }    
}
