package net.sourceforge.ganttproject.gui.taskproperties;

import javax.swing.JComponent;

import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskMutator;

public class TaskCostPage implements IPropertySheetComponent {
	private Task myTask;
	private IGanttProject myProject;
	private boolean isCollapsed;
	private boolean isHidden;
	private TaskMutator myTaskMutator;
	private GPOptionGroup myCostPropertiesGroup;
	private OptionsPageBuilder myBuilder = new OptionsPageBuilder();

	public String getPageName() {
		return GanttLanguage.getInstance().getText("taskProperties.tab.general.label");
	}

	public String getTitle() {
		return myBuilder.getI18N().getOptionGroupLabel(myCostPropertiesGroup);
	}

	public void init(Task task, TaskMutator taskMutator, IGanttProject project, UIFacade uifacade) {
		myTask = task;
		myTaskMutator = taskMutator;
		myProject = project;
		myCostPropertiesGroup = createCostProperties();
		myCostPropertiesGroup.lock();
		myCostPropertiesGroup.setTitled(false);
	}

	public boolean isCollapsed() {
		return isCollapsed;
	}

	public void setCollapsed(boolean collapsed) {
		isCollapsed = collapsed;
	}

	public boolean isHidden() {
		return isHidden;
	}

	public void setHidden(boolean hidden) {
		isHidden = hidden;
	}

	public void onCommit() {
        myCostPropertiesGroup.commit();
        myTaskMutator.commit();
	}

	public void onRollback() {
		myTaskMutator.rollback();
        myCostPropertiesGroup.rollback();
	}

	public Object getAdapter(Class adapter) {
		if (JComponent.class.equals(adapter)) {
			return myBuilder.createGroupComponent(myCostPropertiesGroup);
		}
		return null;
	}

    private GPOptionGroup createCostProperties() {
    	TaskCostFields costFields = new TaskCostFields()
    	{
    		protected Task getTask()
    		{
    			return myTask;
    		}
    		protected TaskMutator getMutator()
    		{
    			return myTaskMutator;
    		}
    		
    		protected void apply()
    		{
    			myTask.getPrice().setIsAuto(isAuto);
    		}
    	};
        return new GPOptionGroup("taskProperties.cost", new GPOption[]{
                costFields.cost, costFields.calcCost
        });
        
    }
	
}
