package net.sourceforge.ganttproject.io;

import javax.xml.transform.sax.TransformerHandler;

import net.sourceforge.ganttproject.gui.TableHeaderUIFacade;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class GanttChartViewSaver extends SaverBase {

    void save(TableHeaderUIFacade tableHeader, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        startElement("taskdisplaycolumns", handler);
        for (int i=0; i<tableHeader.getSize(); i++) {
            TableHeaderUIFacade.Column column = tableHeader.getField(i);
            if (column.isVisible()) {
                addAttribute("property-id", column.getID(), attrs);
                addAttribute("order", String.valueOf(column.getOrder()), attrs);
                addAttribute("width", String.valueOf(column.getWidth()), attrs);
                emptyElement("displaycolumn", attrs, handler);                
            }
        }
        endElement("taskdisplaycolumns", handler);
    }

}
