/*
 * Created on 09.10.2005
 */
package net.sourceforge.ganttproject.print;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.gui.UIFacade;

public class PrintAction extends GPAction {
    private final GPPrintService myPrintService = new GPPrintServiceStub();
    private final IGanttProject myProject;
    private final UIFacade myUIfacade;
    
    public PrintAction(IGanttProject project, UIFacade uifacade) {
        super("print");
        myProject = project;
        myUIfacade = uifacade;
        putValue(Action.ACCELERATOR_KEY, KeyStroke
                .getKeyStroke(KeyEvent.VK_P, MENU_MASK));
        setEnabled(myPrintService.checkPrintingAvailability().isOK());
    }
    
    protected String getLocalizedName() {
        return getI18n("printProject");
    }

    protected String getIconFilePrefix() {
        return "print_";
    }

    public void actionPerformed(ActionEvent e) {
        myPrintService.print(myProject, myUIfacade.getActiveChart(), myUIfacade);
    }

}
