package net.sourceforge.ganttproject.task;

import java.util.List;

/**
 * Created by IntelliJ IDEA. User: bard
 */
public interface TaskContainmentHierarchyFacade {
    Task[] getNestedTasks(Task container);

    boolean hasNestedTasks(Task container);

    Task getRootTask();

    Task getContainer(Task nestedTask);

    void move(Task whatMove, Task newContainer);
    void move(Task whatMove, Task newContainer, int childIndex);

    boolean areUnrelated(Task dependant, Task dependee);

    interface Factory {
        TaskContainmentHierarchyFacade createFacede();
    }

    int getDepth(Task task);
    int compareDocumentOrder(Task task1, Task task2);
    List<Task> getTasksInDocumentOrder();
    
    boolean contains(Task task);

    int getPositionInParent(Task child);

    TaskContainmentHierarchyFacade STUB = new TaskContainmentHierarchyFacade() {

        public Task[] getNestedTasks(Task container) {
            return new Task[0];
        }

        public boolean hasNestedTasks(Task container) {
            return false;
        }

        public Task getRootTask() {
            return null;
        }

        public Task getContainer(Task nestedTask) {
            return null;
        }

        public void move(Task whatMove, Task whereMove) {
        }

        public void move(Task whatMove, Task newContainer, int childIndex) {
        }

        public boolean areUnrelated(Task dependant, Task dependee) {
            return false;
        }

        public int getDepth(Task task) {
            return 0;
        }

        public int compareDocumentOrder(Task next, Task dependeeTask) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Task task) {
            throw new UnsupportedOperationException();
        }

        public List<Task> getTasksInDocumentOrder() {
            throw new UnsupportedOperationException();
        }

        public int getPositionInParent(Task child) {
            return 0;
        }

    };

}