/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGFitToViewBox;

public abstract class AbstractGraphicsNodeBridge
extends AbstractSVGBridge
implements SVGContext,
BridgeUpdateHandler,
GraphicsNodeBridge,
ErrorConstants {
    protected Element e;
    protected GraphicsNode node;
    protected BridgeContext ctx;

    protected AbstractGraphicsNodeBridge() {
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        GraphicsNode graphicsNode = this.instantiateGraphicsNode();
        String string = element.getAttributeNS(null, "transform");
        if (string.length() != 0) {
            graphicsNode.setTransform(SVGUtilities.convertTransform(element, "transform", string));
        }
        graphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        return graphicsNode;
    }

    protected abstract GraphicsNode instantiateGraphicsNode();

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        SVGUtilities.bridgeChildren(bridgeContext, element);
    }

    public boolean getDisplay(Element element) {
        return CSSUtilities.convertDisplay(element);
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        if (!bridgeContext.isInteractive()) {
            return;
        }
        bridgeContext.bind(element, graphicsNode);
        if (bridgeContext.isDynamic()) {
            this.e = element;
            this.node = graphicsNode;
            this.ctx = bridgeContext;
            ((SVGOMElement)element).setSVGContext(this);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("transform")) {
            String string2 = mutationEvent.getNewValue();
            AffineTransform affineTransform = GraphicsNode.IDENTITY;
            if (string2.length() != 0) {
                affineTransform = SVGUtilities.convertTransform(this.e, "transform", string2);
            }
            this.node.setTransform(affineTransform);
            this.handleGeometryChanged();
        }
    }

    protected void handleGeometryChanged() {
        this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
        this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
        this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
        compositeGraphicsNode.remove(this.node);
        AbstractGraphicsNodeBridge.disposeTree(this.e);
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
    }

    public void dispose() {
        SVGOMElement sVGOMElement = (SVGOMElement)this.e;
        sVGOMElement.setSVGContext(null);
        this.ctx.unbind(this.e);
    }

    static void disposeTree(Node node) {
        Node node2;
        BridgeUpdateHandler bridgeUpdateHandler;
        if (node instanceof SVGOMElement && (bridgeUpdateHandler = (BridgeUpdateHandler)((Object)((SVGOMElement)(node2 = (SVGOMElement)node)).getSVGContext())) != null) {
            bridgeUpdateHandler.dispose();
        }
        node2 = node.getFirstChild();
        while (node2 != null) {
            AbstractGraphicsNodeBridge.disposeTree(node2);
            node2 = node2.getNextSibling();
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        try {
            int[] nArray = cSSEngineEvent.getProperties();
            int n = 0;
            while (n < nArray.length) {
                this.handleCSSPropertyChanged(nArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            this.ctx.getUserAgent().displayError(exception);
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 57: {
                this.node.setVisible(CSSUtilities.convertVisibility(this.e));
                break;
            }
            case 38: {
                this.node.setComposite(CSSUtilities.convertOpacity(this.e));
                break;
            }
            case 18: {
                this.node.setFilter(CSSUtilities.convertFilter(this.e, this.node, this.ctx));
                break;
            }
            case 37: {
                this.node.setMask(CSSUtilities.convertMask(this.e, this.node, this.ctx));
                break;
            }
            case 3: {
                this.node.setClip(CSSUtilities.convertClipPath(this.e, this.node, this.ctx));
                break;
            }
            case 40: {
                this.node.setPointerEventType(CSSUtilities.convertPointerEvents(this.e));
                break;
            }
            case 12: {
                if (this.getDisplay(this.e)) break;
                CompositeGraphicsNode compositeGraphicsNode = this.node.getParent();
                int n2 = compositeGraphicsNode.indexOf(this.node);
                compositeGraphicsNode.remove(this.node);
                AbstractGraphicsNodeBridge.disposeTree(this.e);
            }
        }
    }

    public float getPixelUnitToMillimeter() {
        return this.ctx.getUserAgent().getPixelUnitToMillimeter();
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        return this.node.getPrimitiveBounds();
    }

    public AffineTransform getCTM() {
        GraphicsNode graphicsNode = this.node;
        AffineTransform affineTransform = new AffineTransform();
        Element element = this.e;
        while (element != null) {
            AffineTransform affineTransform2;
            if (element instanceof SVGFitToViewBox) {
                affineTransform2 = graphicsNode instanceof CanvasGraphicsNode ? ((CanvasGraphicsNode)graphicsNode).getViewingTransform() : graphicsNode.getTransform();
                if (affineTransform2 == null) break;
                affineTransform.preConcatenate(affineTransform2);
                break;
            }
            affineTransform2 = graphicsNode.getTransform();
            if (affineTransform2 != null) {
                affineTransform.preConcatenate(affineTransform2);
            }
            element = CSSEngine.getParentCSSStylableElement(element);
            graphicsNode = graphicsNode.getParent();
        }
        return affineTransform;
    }

    public AffineTransform getScreenTransform() {
        return this.ctx.getUserAgent().getTransform();
    }

    public void setScreenTransform(AffineTransform affineTransform) {
        this.ctx.getUserAgent().setTransform(affineTransform);
    }

    public AffineTransform getGlobalTransform() {
        return this.node.getGlobalTransform();
    }

    public float getViewportWidth() {
        return this.ctx.getBlockWidth(this.e);
    }

    public float getViewportHeight() {
        return this.ctx.getBlockHeight(this.e);
    }

    public float getFontSize() {
        return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
    }

    public abstract boolean isComposite();
}

