/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.svg.SVGOMCSSImportedElementRoot;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGUseElementBridge
extends AbstractGraphicsNodeBridge {
    protected ReferencedElementMutationListener l;

    public String getLocalName() {
        return "use";
    }

    public Bridge getInstance() {
        return new SVGUseElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.buildCompositeGraphicsNode(bridgeContext, element, null);
        return compositeGraphicsNode;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = XLinkSupport.getXLinkHref(element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        Element element2 = bridgeContext.getReferencedElement(element, string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        SVGOMDocument sVGOMDocument2 = (SVGOMDocument)element2.getOwnerDocument();
        boolean bl = sVGOMDocument2 == sVGOMDocument;
        Object object5 = object4 = bl ? (Element)element2.cloneNode(true) : (Element)sVGOMDocument.importNode(element2, true);
        if ("symbol".equals(object4.getLocalName())) {
            object3 = sVGOMDocument.createElementNS("http://www.w3.org/2000/svg", "svg");
            object2 = object4.getAttributes();
            int n = object2.getLength();
            int n2 = 0;
            while (n2 < n) {
                object = (Attr)object2.item(n2);
                object3.setAttributeNS(object.getNamespaceURI(), object.getName(), object.getValue());
                ++n2;
            }
            object = object4.getFirstChild();
            while (object != null) {
                object3.appendChild((Node)object);
                object = object4.getFirstChild();
            }
            object4 = object3;
        }
        if ("svg".equals(object4.getLocalName())) {
            object3 = element.getAttributeNS(null, "width");
            if (((String)object3).length() != 0) {
                object4.setAttributeNS(null, "width", (String)object3);
            }
            if (((String)(object2 = element.getAttributeNS(null, "height"))).length() != 0) {
                object4.setAttributeNS(null, "height", (String)object2);
            }
        }
        object3 = new SVGOMCSSImportedElementRoot(sVGOMDocument, element, bl);
        ((AbstractParentNode)object3).appendChild((Node)object4);
        object2 = (SVGOMUseElement)element;
        CSSImportedElementRoot cSSImportedElementRoot = ((SVGOMUseElement)object2).getCSSImportedElementRoot();
        if (cSSImportedElementRoot != null) {
            AbstractGraphicsNodeBridge.disposeTree(cSSImportedElementRoot);
        }
        ((SVGOMUseElement)object2).setCSSImportedElementRoot((CSSImportedElementRoot)object3);
        Object object6 = object4;
        CSSUtilities.computeStyleAndURIs(element2, (Element)object4, string);
        object = bridgeContext.getGVTBuilder();
        GraphicsNode graphicsNode = ((GVTBuilder)object).build(bridgeContext, (Element)object6);
        boolean bl2 = true;
        if (compositeGraphicsNode == null) {
            compositeGraphicsNode = new CompositeGraphicsNode();
            bl2 = false;
        }
        if (bl2) {
            int n = compositeGraphicsNode.size();
            int n3 = 0;
            while (n3 < n) {
                compositeGraphicsNode.remove(0);
                ++n3;
            }
        }
        compositeGraphicsNode.getChildren().add(graphicsNode);
        compositeGraphicsNode.setTransform(this.computeTransform(element, bridgeContext));
        compositeGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        Rectangle2D rectangle2D = CSSUtilities.convertEnableBackground(element);
        if (rectangle2D != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        if (bl && bridgeContext.isDynamic()) {
            EventTarget eventTarget;
            if (this.l == null) {
                this.l = new ReferencedElementMutationListener();
                this.l.target = (EventTarget)((Object)element2);
            } else {
                EventTarget eventTarget2 = this.l.target;
                eventTarget2.removeEventListener("DOMAttrModified", this.l, true);
                eventTarget2.removeEventListener("DOMNodeInserted", this.l, true);
                eventTarget2.removeEventListener("DOMNodeRemoved", this.l, true);
                eventTarget2.removeEventListener("DOMCharacterDataModified", this.l, true);
            }
            this.l.target = eventTarget = (EventTarget)((Object)element2);
            eventTarget.addEventListener("DOMAttrModified", this.l, true);
            bridgeContext.storeEventListener(eventTarget, "DOMAttrModified", this.l, true);
            eventTarget.addEventListener("DOMNodeInserted", this.l, true);
            bridgeContext.storeEventListener(eventTarget, "DOMNodeInserted", this.l, true);
            eventTarget.addEventListener("DOMNodeRemoved", this.l, true);
            bridgeContext.storeEventListener(eventTarget, "DOMNodeRemoved", this.l, true);
            eventTarget.addEventListener("DOMCharacterDataModified", this.l, true);
            bridgeContext.storeEventListener(eventTarget, "DOMCharacterDataModified", this.l, true);
        }
        return compositeGraphicsNode;
    }

    public void dispose() {
        SVGOMUseElement sVGOMUseElement = (SVGOMUseElement)this.e;
        if (sVGOMUseElement != null && sVGOMUseElement.getCSSImportedElementRoot() != null) {
            AbstractGraphicsNodeBridge.disposeTree(sVGOMUseElement.getCSSImportedElementRoot());
        }
        super.dispose();
        if (this.l == null) {
            return;
        }
        EventTarget eventTarget = this.l.target;
        eventTarget.removeEventListener("DOMAttrModified", this.l, true);
        eventTarget.removeEventListener("DOMNodeInserted", this.l, true);
        eventTarget.removeEventListener("DOMNodeRemoved", this.l, true);
        eventTarget.removeEventListener("DOMCharacterDataModified", this.l, true);
        this.l = null;
    }

    protected AffineTransform computeTransform(Element element, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        float f = 0.0f;
        String string = element.getAttributeNS(null, "x");
        if (string.length() != 0) {
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        float f2 = 0.0f;
        string = element.getAttributeNS(null, "y");
        if (string.length() != 0) {
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        string = element.getAttributeNS(null, "transform");
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        if (string.length() != 0) {
            affineTransform.preConcatenate(SVGUtilities.convertTransform(element, "transform", string));
        }
        return affineTransform;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        if (bridgeContext.isInteractive()) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            CursorMouseOverListener cursorMouseOverListener = new CursorMouseOverListener(bridgeContext);
            eventTarget.addEventListener("mouseover", cursorMouseOverListener, false);
            bridgeContext.storeEventListener(eventTarget, "mouseover", cursorMouseOverListener, false);
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        Node node = mutationEvent.getRelatedNode();
        if (string.equals("x") || string.equals("y") || string.equals("transform")) {
            this.node.setTransform(this.computeTransform(this.e, this.ctx));
            this.handleGeometryChanged();
        } else if ("http://www.w3.org/1999/xlink".equals(node.getNamespaceURI()) && "href".equals(node.getLocalName())) {
            this.buildCompositeGraphicsNode(this.ctx, this.e, (CompositeGraphicsNode)this.node);
        }
    }

    public class ReferencedElementMutationListener
    implements EventListener {
        EventTarget target;

        public void handleEvent(Event event) {
            SVGUseElementBridge.this.buildCompositeGraphicsNode(SVGUseElementBridge.this.ctx, SVGUseElementBridge.this.e, (CompositeGraphicsNode)SVGUseElementBridge.this.node);
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected BridgeContext ctx;

        public CursorMouseOverListener(BridgeContext bridgeContext) {
            this.ctx = bridgeContext;
        }

        public void handleEvent(Event event) {
            Cursor cursor;
            Element element = (Element)((Object)event.getCurrentTarget());
            if (!CSSUtilities.isAutoCursor(element) && (cursor = CSSUtilities.convertCursor(element, this.ctx)) != null) {
                this.ctx.getUserAgent().setSVGCursor(cursor);
            }
        }
    }
}

