/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.SVGLine;
import org.w3c.dom.Element;

public class SVGEllipse
extends SVGGraphicObjectConverter {
    private SVGLine svgLine;

    public SVGEllipse(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
        this.svgLine = new SVGLine(sVGGeneratorContext);
    }

    public Element toSVG(Ellipse2D ellipse2D) {
        if (ellipse2D.getWidth() < 0.0 || ellipse2D.getHeight() < 0.0) {
            return null;
        }
        if (ellipse2D.getWidth() == ellipse2D.getHeight()) {
            return this.toSVGCircle(ellipse2D);
        }
        return this.toSVGEllipse(ellipse2D);
    }

    private Element toSVGCircle(Ellipse2D ellipse2D) {
        Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "circle");
        element.setAttributeNS(null, "cx", this.doubleString(ellipse2D.getX() + ellipse2D.getWidth() / 2.0));
        element.setAttributeNS(null, "cy", this.doubleString(ellipse2D.getY() + ellipse2D.getHeight() / 2.0));
        element.setAttributeNS(null, "r", this.doubleString(ellipse2D.getWidth() / 2.0));
        return element;
    }

    private Element toSVGEllipse(Ellipse2D ellipse2D) {
        if (ellipse2D.getWidth() > 0.0 && ellipse2D.getHeight() > 0.0) {
            Element element = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "ellipse");
            element.setAttributeNS(null, "cx", this.doubleString(ellipse2D.getX() + ellipse2D.getWidth() / 2.0));
            element.setAttributeNS(null, "cy", this.doubleString(ellipse2D.getY() + ellipse2D.getHeight() / 2.0));
            element.setAttributeNS(null, "rx", this.doubleString(ellipse2D.getWidth() / 2.0));
            element.setAttributeNS(null, "ry", this.doubleString(ellipse2D.getHeight() / 2.0));
            return element;
        }
        if (ellipse2D.getWidth() == 0.0 && ellipse2D.getHeight() > 0.0) {
            Line2D.Double double_ = new Line2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getX(), ellipse2D.getY() + ellipse2D.getHeight());
            return this.svgLine.toSVG(double_);
        }
        if (ellipse2D.getWidth() > 0.0 && ellipse2D.getHeight() == 0.0) {
            Line2D.Double double_ = new Line2D.Double(ellipse2D.getX(), ellipse2D.getY(), ellipse2D.getX() + ellipse2D.getWidth(), ellipse2D.getY());
            return this.svgLine.toSVG(double_);
        }
        return null;
    }
}

