/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HRational;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import java.math.BigInteger;
import java.util.Vector;

public class HFraction
implements HObject,
HRational {
    BigInteger numer;
    BigInteger denom;
    public static final HFraction F1 = new HFraction(HInteger.I1, HInteger.I1);
    public static final HFraction F0 = new HFraction(HInteger.I0, HInteger.I1);
    public static final HFraction FN1 = new HFraction(HInteger.IN1, HInteger.I1);
    public Vector geonextElements = new Vector();

    public HFraction(byte[] byArray, byte[] byArray2) {
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = new BigInteger(byArray2);
        BigInteger bigInteger3 = bigInteger2.gcd(bigInteger);
        if (bigInteger2.compareTo(HInteger.B0) == -1) {
            bigInteger2 = bigInteger2.negate();
            bigInteger = bigInteger.negate();
        }
        if (bigInteger3.compareTo(HInteger.B1) != 0) {
            bigInteger = bigInteger.divide(bigInteger3);
            bigInteger2 = bigInteger2.divide(bigInteger3);
        }
        this.numer = bigInteger;
        this.denom = bigInteger2;
    }

    public HFraction(HInteger hInteger, HInteger hInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = hInteger.bigIntegerValue();
        if (hInteger2.isZero()) {
            throw new ArithmeticException();
        }
        BigInteger bigInteger3 = hInteger2.bigIntegerValue();
        if (bigInteger3.compareTo(HInteger.B0) == -1) {
            bigInteger3 = bigInteger3.negate();
            bigInteger2 = bigInteger2.negate();
        }
        if ((bigInteger = bigInteger3.gcd(bigInteger2)).compareTo(HInteger.B1) != 0) {
            bigInteger2 = bigInteger2.divide(bigInteger);
            bigInteger3 = bigInteger3.divide(bigInteger);
        }
        this.denom = bigInteger3;
        this.numer = bigInteger2;
    }

    HFraction(String string, int n, String string2, int n2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = new BigInteger(string, n);
        BigInteger bigInteger3 = new BigInteger(string2, n2);
        if (bigInteger3.compareTo(HInteger.B0) == -1) {
            bigInteger3 = bigInteger3.negate();
            bigInteger2 = bigInteger2.negate();
        }
        if ((bigInteger = bigInteger3.gcd(bigInteger2)).compareTo(HInteger.B1) != 0) {
            bigInteger2 = bigInteger2.divide(bigInteger);
            bigInteger3 = bigInteger3.divide(bigInteger);
        }
        this.denom = bigInteger3;
        this.numer = bigInteger2;
    }

    public HFraction(String string, String string2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = new BigInteger(string);
        BigInteger bigInteger3 = new BigInteger(string2);
        if (bigInteger3.compareTo(HInteger.B0) == -1) {
            bigInteger3 = bigInteger3.negate();
            bigInteger2 = bigInteger2.negate();
        }
        if ((bigInteger = bigInteger3.gcd(bigInteger2)).compareTo(HInteger.B1) != 0) {
            bigInteger2 = bigInteger2.divide(bigInteger);
            bigInteger3 = bigInteger3.divide(bigInteger);
        }
        this.denom = bigInteger3;
        this.numer = bigInteger2;
    }

    public HFraction(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.compareTo(HInteger.B0) == 0) {
            throw new ArithmeticException();
        }
        BigInteger bigInteger3 = bigInteger2.gcd(bigInteger);
        if (bigInteger2.compareTo(HInteger.B0) == -1) {
            bigInteger2 = bigInteger2.negate();
            bigInteger = bigInteger.negate();
        }
        if (bigInteger3.compareTo(HInteger.B1) != 0) {
            bigInteger = bigInteger.divide(bigInteger3);
            bigInteger2 = bigInteger2.divide(bigInteger3);
        }
        this.numer = bigInteger;
        this.denom = bigInteger2;
    }

    public HObject abs() {
        return new HFraction(this.numer.abs(), this.denom);
    }

    public HFraction add(HFraction hFraction) throws ArithmeticException {
        BigInteger bigInteger = this.numer.multiply(hFraction.denom).add(this.denom.multiply(hFraction.numer));
        BigInteger bigInteger2 = this.denom.multiply(hFraction.denom);
        if (bigInteger2.compareTo(HInteger.B0) < 0) {
            bigInteger2 = bigInteger2.negate();
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        return new HFraction(bigInteger.divide(bigInteger3), bigInteger2.divide(bigInteger3));
    }

    public HObject apply(HObject hObject) {
        if (hObject instanceof HSymbol) {
            return C.EV(new HFunction((HSymbol)hObject, this));
        }
        if (hObject instanceof HFunction && ((HFunction)hObject).isPureFunction()) {
            HFunction hFunction = (HFunction)((HFunction)hObject).clone();
            hFunction.add(this);
            return C.EV(hFunction);
        }
        throw new HThrowException(C.HeadFormatError, C.Lambda, hObject);
    }

    public HObject ceil() {
        BigInteger[] bigIntegerArray = this.numer.divideAndRemainder(this.denom);
        if (bigIntegerArray[1].compareTo(HInteger.B0) <= 0) {
            return new HInteger(bigIntegerArray[0]);
        }
        return new HInteger(bigIntegerArray[0].add(HInteger.B1));
    }

    public int compSignum() {
        return this.signum();
    }

    public HObject conjugate() {
        return this;
    }

    public HInteger denom() {
        return new HInteger(this.denom);
    }

    public HFraction divide(HFraction hFraction) throws ArithmeticException {
        BigInteger bigInteger = this.numer.multiply(hFraction.denom);
        BigInteger bigInteger2 = this.denom.multiply(hFraction.numer);
        if (bigInteger2.compareTo(HInteger.B0) < 0) {
            bigInteger2 = bigInteger2.negate();
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        return new HFraction(bigInteger.divide(bigInteger3), bigInteger2.divide(bigInteger3));
    }

    public double doubleValue() {
        return this.numer.doubleValue() / this.denom.doubleValue();
    }

    public boolean equals(Object object) {
        if (object instanceof HFraction) {
            return this.numer.equals(((HFraction)object).numer) && this.denom.equals(((HFraction)object).denom);
        }
        return object instanceof HInteger && this.denom.equals(HInteger.B1) && ((HInteger)object).biggi.equals(this.numer);
    }

    public HObject evaluate() {
        if (SessionData.getCurrentNumericFlag()) {
            return new HDouble(this.numer.doubleValue() / this.denom.doubleValue());
        }
        return null;
    }

    public float floatValue() {
        return this.numer.floatValue() / this.denom.floatValue();
    }

    public HObject floor() {
        BigInteger[] bigIntegerArray = this.numer.divideAndRemainder(this.denom);
        if (bigIntegerArray[1].compareTo(HInteger.B0) >= 0) {
            return new HInteger(bigIntegerArray[0]);
        }
        return new HInteger(bigIntegerArray[0].subtract(HInteger.B1));
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        return this.numer.hashCode() + this.denom.hashCode();
    }

    public HSymbol head() {
        return C.Fraction;
    }

    public final int hierarchy() {
        return 8;
    }

    public HObject im() {
        return C.C0;
    }

    public int intValue() {
        if (this.denom.compareTo(HInteger.B1) != 0) {
            throw new ArithmeticException();
        }
        return this.numer.intValue();
    }

    public boolean isEqual(HFraction hFraction) {
        return this.numer.equals(hFraction.numer) && this.denom.equals(hFraction.denom);
    }

    public boolean isGreater(HFraction hFraction) {
        return hFraction.less(this);
    }

    public boolean isHeadMember(HSymbol hSymbol) {
        return C.Fraction.equals(hSymbol);
    }

    public boolean isLess(HFraction hFraction) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.numer.multiply(hFraction.denom);
        return bigInteger2.compareTo(bigInteger = this.denom.multiply(hFraction.numer)) == -1;
    }

    public boolean isList() {
        return false;
    }

    public boolean isMember(HObject hObject) {
        return this.equals(hObject);
    }

    public boolean isNegative() {
        return this.numer.compareTo(HInteger.B0) == -1;
    }

    public boolean isNonNegative() {
        return this.numer.compareTo(HInteger.B0) >= 0;
    }

    public boolean isNonZero() {
        return this.numer.compareTo(HInteger.B0) != 0;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isPositive() {
        return this.numer.compareTo(HInteger.B0) == 1;
    }

    public boolean isRational() {
        return true;
    }

    public boolean isUnequal(HFraction hFraction) {
        return !this.isEqual(hFraction);
    }

    public boolean isZero() {
        return this.numer.compareTo(HInteger.B0) == 0;
    }

    public boolean less(Object object) {
        if (object instanceof HInteger) {
            BigInteger bigInteger = this.denom.multiply(((HInteger)object).biggi);
            return this.numer.compareTo(bigInteger) == -1;
        }
        if (object instanceof HFraction) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = this.numer.multiply(((HFraction)object).denom);
            return bigInteger2.compareTo(bigInteger = this.denom.multiply(((HFraction)object).numer)) == -1;
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public long longValue() {
        if (this.denom.compareTo(HInteger.B1) != 0) {
            throw new ArithmeticException();
        }
        return this.numer.longValue();
    }

    public boolean matches(HObject hObject) {
        return this.equals(hObject);
    }

    public HFraction max(HFraction hFraction) {
        if (this.isLess(hFraction)) {
            return hFraction;
        }
        return this;
    }

    public HFraction min(HFraction hFraction) {
        if (this.isLess(hFraction)) {
            return this;
        }
        return hFraction;
    }

    public HFraction multiply(HFraction hFraction) {
        BigInteger bigInteger = this.numer.multiply(hFraction.numer);
        BigInteger bigInteger2 = this.denom.multiply(hFraction.denom);
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        return new HFraction(bigInteger.divide(bigInteger3), bigInteger2.divide(bigInteger3));
    }

    public HFraction multiply(HInteger hInteger) {
        BigInteger bigInteger = this.numer.multiply(hInteger.biggi);
        BigInteger bigInteger2 = bigInteger.gcd(this.denom);
        return new HFraction(bigInteger.divide(bigInteger2), this.denom.divide(bigInteger2));
    }

    public HFraction negate() {
        return new HFraction(this.numer.negate(), this.denom);
    }

    public HInteger numer() {
        return new HInteger(this.numer);
    }

    public HFraction pow(int n) throws ArithmeticException {
        if (n < 0) {
            return new HFraction(this.denom.pow(n *= -1), this.numer.pow(n));
        }
        return new HFraction(this.numer.pow(n), this.denom.pow(n));
    }

    public int precedence() {
        if (this.numer.compareTo(HInteger.B0) == -1) {
            return 100;
        }
        return 999999;
    }

    public HObject re() {
        return this;
    }

    public HObject round(HDouble hDouble) {
        return new HDouble(this.doubleValue()).round(hDouble);
    }

    public HObject round(HInteger hInteger) {
        return new HDouble(this.doubleValue()).round(hInteger);
    }

    public HFraction shiftLeft(int n) {
        return new HFraction(this.numer.shiftLeft(n), this.denom);
    }

    public HFraction shiftRight(int n) {
        return new HFraction(this.numer.shiftRight(n), this.denom);
    }

    public int signum() {
        return this.numer.signum();
    }

    public HObject substitute(HObject hObject, HObject hObject2) {
        if (this.equals(hObject)) {
            return hObject2;
        }
        return this;
    }

    public HObject substitutePattern() {
        return this;
    }

    public HFraction subtract(HFraction hFraction) {
        BigInteger bigInteger = this.numer.multiply(hFraction.denom).subtract(this.denom.multiply(hFraction.numer));
        BigInteger bigInteger2 = this.denom.multiply(hFraction.denom);
        if (bigInteger2.compareTo(HInteger.B0) < 0) {
            bigInteger2 = bigInteger2.negate();
            bigInteger = bigInteger.negate();
        }
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        return new HFraction(bigInteger.divide(bigInteger3), bigInteger2.divide(bigInteger3));
    }

    public BigInteger toBigIntegerDenominator() {
        return this.denom;
    }

    public BigInteger toBigIntegerNumerator() {
        return this.numer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        if (this.denom.compareTo(HInteger.B1) == 0) {
            stringBuffer.append(this.numer.toString());
        } else {
            stringBuffer.append(this.numer.toString());
            stringBuffer.append('/');
            stringBuffer.append(this.denom.toString());
        }
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }

    public static HFraction valueOf(long l, long l2) {
        return new HFraction(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }
}

