/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.initial;

import com.hartmath.expression.HArrayList;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.mapping.E2Arg;
import com.hartmath.mapping.FunctionEvaluator;
import com.hartmath.mapping.FunctionOpEvaluator;

class ESet
implements FunctionEvaluator,
FunctionOpEvaluator {
    ESet() {
    }

    public HObject evaluate(HFunction hFunction) {
        if (hFunction.size() == 2) {
            HObject hObject = hFunction.get(0);
            HObject hObject2 = C.SEV(hFunction.get(1));
            if (hObject instanceof HSymbol) {
                ((HSymbol)hObject).putDownRule(4096, hObject, hObject2);
                return hObject2;
            }
            if (hObject instanceof HFunction) {
                HFunction hFunction2 = (HFunction)hObject;
                if (hFunction2.head().equals(C.Part) && hFunction2.get(0) instanceof HSymbol && hFunction2.get(1) instanceof HInteger && hFunction2.size() == 2) {
                    HObject hObject3;
                    HSymbol hSymbol = (HSymbol)hFunction2.get(0);
                    if (!hSymbol.hasNoLocalVar()) {
                        HObject hObject4 = hSymbol.deleteLocalVar();
                        HObject hObject5 = this.execute(hObject4, (HInteger)hFunction2.get(1), hObject2);
                        if (hObject5 != null) {
                            hSymbol.createLocalVar(hObject5);
                            return hObject2;
                        }
                        hSymbol.createLocalVar(hObject4);
                        return null;
                    }
                    HObject hObject6 = hSymbol.getDownRule(hSymbol);
                    if (hObject6 != null && (hObject3 = this.execute(hObject6, (HInteger)hFunction2.get(1), hObject2)) != null) {
                        hSymbol.putDownRule(4096, hSymbol, hObject3);
                        return hObject2;
                    }
                    StringBuffer stringBuffer = new StringBuffer("index ");
                    stringBuffer.append(((HInteger)hFunction2.get(1)).toString());
                    stringBuffer.append(" out of range [..] in expression: ");
                    stringBuffer.append(hFunction2.get(0).toString());
                    throw new HThrowException(C.OutOfRangeError, C.Part, new HString(stringBuffer.toString()));
                }
                if ((hFunction2 = hFunction2.evaluateLHSAttr()) == null) {
                    hFunction2 = (HFunction)hObject;
                }
                ((HFunction)hObject).head().putDownRule(4096, hFunction2, hObject2);
                return hObject2;
            }
        }
        return null;
    }

    public HObject execute(HObject hObject, HInteger hInteger, HObject hObject2) {
        Object object;
        int n = 0;
        if (hObject instanceof HFunction) {
            object = (HFunction)((HFunction)hObject).clone();
            n = ((HArrayList)object).size();
            if (hInteger.checkRange(1L, ((HArrayList)object).size())) {
                int n2 = hInteger.intValue();
                ((HArrayList)object).set(n2 - 1, hObject2);
                return object;
            }
        }
        object = new StringBuffer("index ");
        ((StringBuffer)object).append(hInteger.toString());
        ((StringBuffer)object).append(" out of range [1..");
        ((StringBuffer)object).append(new Integer(n).toString());
        ((StringBuffer)object).append("] in expression: ");
        ((StringBuffer)object).append(hObject.toString());
        throw new HThrowException(C.OutOfRangeError, C.Part, new HString(((StringBuffer)object).toString()));
    }

    public int precedence() {
        return 20;
    }

    public String toOpString(HFunction hFunction) {
        return E2Arg.operatorString(hFunction, "=", 20);
    }
}

