/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.mapping;

import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;

public class HUnaryNumerical {
    HObject fun;
    HObject variable;

    public HUnaryNumerical(HObject hObject, HObject hObject2) {
        this.variable = hObject2;
        this.fun = hObject;
    }

    public HUnaryNumerical(HObject hObject, String string) {
        this.variable = new HSymbol(string).addSymbol();
        this.fun = hObject;
    }

    public Object execute(Object object) {
        return C.NEV(this.fun.substitute(this.variable, (HObject)object));
    }

    public double map(double d) {
        Object object = this.execute(new HDouble(d));
        if (object instanceof HDouble) {
            return ((HDouble)object).doubleValue();
        }
        throw new HThrowException(C.ArithmeticError, C.N, new HString("double value expected"));
    }

    public HDoubleComplex map(HDoubleComplex hDoubleComplex) {
        Object object = this.execute(hDoubleComplex);
        if (object instanceof HDoubleComplex) {
            return (HDoubleComplex)object;
        }
        if (object instanceof HDouble) {
            return new HDoubleComplex((HDouble)object);
        }
        throw new HThrowException(C.ArithmeticError, C.N, new HString("numerical complex value expected"));
    }
}

