/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.patternmatching;

import com.hartmath.expression.HArrayList;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HBreakException;
import com.hartmath.lib.HContinueException;
import com.hartmath.lib.HReturnException;
import com.hartmath.lib.SessionData;
import com.hartmath.patternmatching.HHashNumber;
import com.hartmath.patternmatching.HRule;
import com.hartmath.patternmatching.MatchingFailed;
import com.hartmath.patternmatching.PatternMatching;
import org.kaffe.java.util.AbstractMapEntry;
import org.kaffe.java.util.ArrayList;
import org.kaffe.java.util.HashMap;
import org.kaffe.java.util.Iterator;

public class HRuleSet {
    private HashMap EqualDownRules = new HashMap();
    private HashMap PatternDownRules = new HashMap();
    private HashMap EqualUpRules = new HashMap();
    private HashMap PatternUpRules = new HashMap();
    final HSymbol symb;

    public HRuleSet(HSymbol hSymbol) {
        this.symb = hSymbol;
    }

    public void clear() {
        this.EqualUpRules.clear();
        this.PatternUpRules.clear();
        this.EqualDownRules.clear();
        this.PatternDownRules.clear();
    }

    public void clearSymbolRule(HSymbol hSymbol) {
        if (hSymbol instanceof HSymbol) {
            if (!hSymbol.hasNoLocalVar()) {
                hSymbol.deleteLocalVar();
                hSymbol.createLocalVar(null);
            } else {
                HRule hRule = new HRule(4096, hSymbol, null);
                this.EqualDownRules.remove(hRule);
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HRuleSet) {
            return this.symb.equals(((HRuleSet)object).symb);
        }
        return false;
    }

    public String getDefinition() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            ArrayList arrayList;
            Iterator iterator = this.EqualUpRules.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((AbstractMapEntry)iterator.next()).getValue().toString());
                stringBuffer.append("\n");
            }
            iterator = this.PatternUpRules.entrySet().iterator();
            while (iterator.hasNext()) {
                arrayList = (ArrayList)((AbstractMapEntry)iterator.next()).getValue();
                for (n = 0; n < arrayList.size(); ++n) {
                    stringBuffer.append(arrayList.get(n).toString());
                    stringBuffer.append("\n");
                }
            }
            iterator = this.EqualDownRules.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((AbstractMapEntry)iterator.next()).getValue().toString());
                stringBuffer.append("\n");
            }
            iterator = this.PatternDownRules.entrySet().iterator();
            while (iterator.hasNext()) {
                arrayList = (ArrayList)((AbstractMapEntry)iterator.next()).getValue();
                for (n = 0; n < arrayList.size(); ++n) {
                    stringBuffer.append(arrayList.get(n).toString());
                    stringBuffer.append("\n");
                }
            }
        }
        catch (Throwable throwable) {
            SessionData.appendCurrentErrorOut("Exception occured: " + throwable.getMessage());
        }
        return stringBuffer.toString();
    }

    public HObject getDownRule(HObject hObject) {
        HObject hObject2;
        HRule hRule;
        if (!this.EqualDownRules.isEmpty() && (hRule = (HRule)this.EqualDownRules.get(new HRule(4096, hObject, null))) != null) {
            return C.EV(hRule.rhs());
        }
        if (this.PatternDownRules.isEmpty()) {
            return null;
        }
        if (!(hObject instanceof HFunction)) {
            return null;
        }
        hRule = new HRule(4096, hObject, null);
        HFunction hFunction = (HFunction)hObject;
        int n = hFunction.getAttributes();
        if ((8 & n) == 8) {
            for (int i = 0; i < hFunction.size(); ++i) {
                hRule = new HRule(4096, new HFunction(hObject.head(), hFunction.get(i)), null);
                hObject2 = this.testDownRules(hRule, (HFunction)hObject);
                if (hObject2 == null) continue;
                return hObject2;
            }
        } else {
            hObject2 = this.testDownRules(hRule, (HFunction)hObject);
            if (hObject2 != null) {
                return hObject2;
            }
        }
        if ((hObject2 = this.testDownRules(hRule = new HRule(4096, hFunction = new HFunction(hObject.head(), new HPattern(C.x)), null), (HFunction)hObject)) != null) {
            return hObject2;
        }
        return null;
    }

    public HSymbol getSymbol() {
        return this.symb;
    }

    public HObject getUpRule(HObject hObject) {
        HRule hRule;
        if (!this.EqualUpRules.isEmpty() && (hRule = (HRule)this.EqualUpRules.get(new HRule(4096, hObject, null))) != null) {
            return C.EV(hRule.rhs());
        }
        if (this.PatternUpRules.isEmpty()) {
            return null;
        }
        if (!(hObject instanceof HFunction)) {
            return null;
        }
        hRule = new HRule(4096, hObject, null);
        HFunction hFunction = (HFunction)hObject;
        int n = hFunction.getAttributes();
        if ((8 & n) == 8) {
            for (int i = 0; i < hFunction.size(); ++i) {
                hRule = new HRule(4096, new HFunction(hObject.head(), hFunction.get(i)), null);
                HObject hObject2 = this.testUpRules(hRule, (HFunction)hObject);
                if (hObject2 == null) continue;
                return hObject2;
            }
        } else {
            HObject hObject3 = this.testUpRules(hRule, (HFunction)hObject);
            if (hObject3 != null) {
                return hObject3;
            }
        }
        return null;
    }

    public int hashCode() {
        return this.symb.hashCode();
    }

    public boolean isEmptyDownRule() {
        return this.EqualDownRules.isEmpty() && this.PatternDownRules.isEmpty();
    }

    public boolean isEmptyUpRule() {
        return this.EqualUpRules.isEmpty() && this.PatternUpRules.isEmpty();
    }

    public boolean matchDownRule(HObject hObject) {
        return this.getDownRule(hObject) != null;
    }

    public boolean matchUpRule(HObject hObject) {
        return this.getUpRule(hObject) != null;
    }

    public void putDownRule(int n, HObject hObject, HObject hObject2) {
        HRule hRule = new HRule(n, hObject, hObject2);
        if (hObject instanceof HSymbol) {
            if (!((HSymbol)hObject).hasNoLocalVar()) {
                ((HSymbol)hObject).deleteLocalVar();
                ((HSymbol)hObject).createLocalVar(hObject2);
            } else {
                this.EqualDownRules.put(hRule, hRule);
            }
        } else if (hObject instanceof HFunction && ((HFunction)hObject).isEqualRule() == 0) {
            this.EqualDownRules.put(hRule, hRule);
        } else {
            ArrayList arrayList = (ArrayList)this.PatternDownRules.get(new HHashNumber(hRule));
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(hRule);
                this.PatternDownRules.put(new HHashNumber(hRule), arrayList);
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!hRule.equals(arrayList.get(i))) continue;
                    arrayList.set(i, hRule);
                    return;
                }
                arrayList.add(hRule);
            }
        }
    }

    public void putUpRule(int n, HObject hObject, HObject hObject2) {
        HRule hRule = new HRule(n, hObject, hObject2);
        if (hObject instanceof HSymbol) {
            if (!((HSymbol)hObject).hasNoLocalVar()) {
                ((HSymbol)hObject).deleteLocalVar();
                ((HSymbol)hObject).createLocalVar(hObject2);
            } else {
                this.EqualUpRules.put(hRule, hRule);
            }
        } else if (hObject instanceof HFunction && ((HFunction)hObject).isEqualRule() == 0) {
            this.EqualUpRules.put(hRule, hRule);
        } else {
            ArrayList arrayList = (ArrayList)this.PatternUpRules.get(new HHashNumber(hRule));
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(hRule);
                this.PatternUpRules.put(new HHashNumber(hRule), arrayList);
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!hRule.equals(arrayList.get(i))) continue;
                    arrayList.set(i, hRule);
                    return;
                }
                arrayList.add(hRule);
            }
        }
    }

    HObject testDownRules(HRule hRule, HFunction hFunction) {
        ArrayList arrayList = (ArrayList)this.PatternDownRules.get(new HHashNumber(hRule));
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                HRule hRule2 = (HRule)arrayList.get(i);
                HFunction hFunction2 = (HFunction)hRule2.lhs();
                HArrayList hArrayList = new HArrayList();
                hFunction2.initPattern(hArrayList);
                C.RHS__.initValue();
                hArrayList.add(C.RHS__);
                try {
                    PatternMatching patternMatching = new PatternMatching(hRule2.lhs, hRule2.rhs);
                    if (patternMatching.execute(hFunction2, hFunction)) {
                        HFunction.resetPattern(hArrayList);
                        return patternMatching.getResult();
                    }
                }
                catch (MatchingFailed matchingFailed) {
                }
                catch (HBreakException hBreakException) {
                }
                catch (HContinueException hContinueException) {
                }
                catch (HReturnException hReturnException) {
                    HFunction.resetPattern(hArrayList);
                    return hReturnException.getValue();
                }
                HFunction.resetPattern(hArrayList);
            }
        }
        return null;
    }

    HObject testUpRules(HRule hRule, HFunction hFunction) {
        ArrayList arrayList = (ArrayList)this.PatternUpRules.get(new HHashNumber(hRule));
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                HRule hRule2 = (HRule)arrayList.get(i);
                HFunction hFunction2 = (HFunction)hRule2.lhs();
                HArrayList hArrayList = new HArrayList();
                hFunction2.initPattern(hArrayList);
                C.RHS__.initValue();
                hArrayList.add(C.RHS__);
                try {
                    PatternMatching patternMatching = new PatternMatching(hRule2.lhs, hRule2.rhs());
                    if (patternMatching.execute(hFunction2, hFunction)) {
                        HFunction.resetPattern(hArrayList);
                        return patternMatching.getResult();
                    }
                }
                catch (MatchingFailed matchingFailed) {
                }
                catch (HBreakException hBreakException) {
                }
                catch (HContinueException hContinueException) {
                }
                catch (HReturnException hReturnException) {
                    HFunction.resetPattern(hArrayList);
                    return hReturnException.getValue();
                }
                HFunction.resetPattern(hArrayList);
            }
        }
        return null;
    }
}

