/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Point;
import geonext.Text;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class Angle
extends Element
implements MouseListener,
MouseMotionListener {
    public Point A;
    public Point S;
    public Point B;
    public double r;
    public double posA;
    public Text text = new Text("", 0, "", 0);
    public double posB;

    public Angle() {
        this.initAngle();
        this.A = new Point();
        this.A.setChanged(false);
        this.B = new Point();
        this.B.setChanged(false);
        this.S = new Point();
        this.S.setChanged(false);
        this.r = 1.0;
    }

    public Angle(String string, int n, Point point, Point point2, Point point3, int n2) {
        super(string, n, n2);
        this.A = point;
        this.B = point3;
        this.S = point2;
        this.r = 1.0;
        this.initAngle();
    }

    public void calculate(boolean bl) {
        this.calculateChanged(bl);
    }

    public Vector data() {
        Vector<Point> vector = new Vector<Point>();
        vector.addElement(this.getA());
        vector.addElement(this.getB());
        vector.addElement(this.getS());
        return vector;
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("angle_description"));
    }

    public double distance(Point point, Point point2) {
        return Math.sqrt((point.getScreenX() - point2.getScreenX()) * (point.getScreenX() - point2.getScreenX()) + (point.getScreenY() - point2.getScreenY()) * (point.getScreenY() - point2.getScreenY()));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            double d = this.getDEG(this.getS(), this.getA());
            double d2 = this.getDEG(this.getS(), this.getB());
            double d3 = Math.PI * (d < d2 ? d2 + d : d + d2 - 360.0) / 360.0;
            double d4 = this.getR();
            double d5 = jBoardPane.user2screenX(2.0 * d4 / 3.0) - jBoardPane.origin.getWidth();
            if (!this.isDraft()) {
                graphics2D.setColor(this.getFill());
                graphics2D.fillArc(jBoardPane.round(jBoardPane.user2screenX(this.getS().getUserX() - d4)), jBoardPane.round(jBoardPane.user2screenY(this.getS().getUserY() + d4)), 2 * jBoardPane.round(jBoardPane.user2screenX(d4) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d4) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d), jBoardPane.round(d < d2 ? d2 - d : 360.0 - d + d2));
                graphics2D.setColor(this.getStroke());
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            graphics2D.drawArc(jBoardPane.round(jBoardPane.user2screenX(this.getS().getUserX() - d4)), jBoardPane.round(jBoardPane.user2screenY(this.getS().getUserY() + d4)), 2 * jBoardPane.round(jBoardPane.user2screenX(d4) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d4) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d), jBoardPane.round(d < d2 ? d2 - d : 360.0 - d + d2));
            if (this.isNameDrawed()) {
                if (!this.isDraft()) {
                    graphics2D.setColor(this.getLabel());
                } else {
                    graphics2D.setColor(this.getDraftColor());
                }
                if (this.isTextName() && this.getNameText() != null) {
                    jBoardPane.drawName(graphics2D, this.getText(), jBoardPane.round(this.getS().getScreenX() + Math.cos(d3) * d5), jBoardPane.round(this.getS().getScreenY() - Math.sin(d3) * d5), graphics2D.getColor(), 0, 12);
                } else {
                    jBoardPane.drawName(graphics2D, this.getText().getText(), jBoardPane.round(this.getS().getScreenX() + Math.cos(d3) * d5), jBoardPane.round(this.getS().getScreenY() - Math.sin(d3) * d5), graphics2D.getColor(), 0, 12);
                }
            }
        }
    }

    public boolean exists() {
        return this.A.exists() && this.B.exists() && this.S.exists();
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterAngle++;
        String string2 = Geonext.language.getString("angle_auto_name");
        while (!bl) {
            if (elementSet.searchName(string2 + "" + n) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterAngle;
        }
        this.setName(string2 + "" + n);
        bl = false;
        string = "";
        n = elementSet.nameCounterAngleText++;
        while (!bl) {
            string = n < 25 ? "&" + JBoardPane.greek[n] + ";" : "&alpha;_{" + (n - 24) + "}";
            if (elementSet.searchAngleText(string) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterAngleText;
        }
        this.text.setText("" + string);
    }

    public Point getA() {
        return this.A;
    }

    public Point getB() {
        return this.B;
    }

    public double getR() {
        return this.r;
    }

    public Point getS() {
        return this.S;
    }

    public Text getText() {
        return this.text;
    }

    public Coordinates getTextAnchor() {
        return this.getS().user;
    }

    public String getTextvalue() {
        return this.text.getText();
    }

    public void initAngle() {
        this.area = 3;
        this.stroke = new Color(255, 127, 0, 100);
        this.fill = new Color(255, 127, 0, 50);
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0);
        this.typeString = "angle";
        this.setElementName(Geonext.language.getString("angle_element_name"));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Point point = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "first")[1]);
            Point point2 = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "last")[1]);
            Point point3 = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "middle")[1]);
            if (point == null || point2 == null || point3 == null || point.equals(point2) || point.equals(point3) || point3.equals(point2)) {
                return false;
            }
            jBoardPane.createAngle(point, point3, point2, string2, false);
            Angle angle = (Angle)jBoardPane.element.angle.lastElement();
            angle.setR(this.tag(string3, "radius")[1]);
            string = angle.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String parseProperties(String string) {
        super.parseProperties(string);
        this.getText().setText(this.tag(string, "text")[1]);
        string = this.tag(string, "text")[0];
        return string;
    }

    public void setA(Point point) {
        this.A = point;
    }

    public void setB(Point point) {
        this.B = point;
    }

    public void setR(double d) {
        this.r = d;
    }

    public void setR(int n) {
        this.r = n;
    }

    public void setR(String string) {
        try {
            this.setR(new Double(string));
        }
        catch (Exception exception) {
            this.setR(1);
        }
    }

    public void setS(Point point) {
        this.S = point;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setText(String string) {
        this.setText(new Text("", -1, string, 0));
    }

    public void setRadius(String string) {
        try {
            this.setR(new Integer(string));
        }
        catch (Exception exception) {
            this.setR(1);
        }
    }

    public double getRadius() {
        return this.getR();
    }

    public String svg() {
        return "";
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<first>" + this.getA().getId() + "</first>\n ";
        string2 = string2 + string + "<middle>" + this.getS().getId() + "</middle>\n ";
        string2 = string2 + string + "<last>" + this.getB().getId() + "</last>\n ";
        string2 = string2 + string + "<radius>" + this.getR() + "</radius>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<text>" + this.getText().getText() + "</text>\n ";
        return string2;
    }

    public String shortInfo() {
        return this.generateShort(Geonext.language.getString("angle_short"));
    }
}

