/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Arrow;
import geonext.Circle;
import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.Point;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class Arc
extends Circle
implements MouseListener,
MouseMotionListener {
    public Point A;
    public boolean fullCircle;
    public boolean firstArrow = false;
    public boolean lastArrow = false;

    public Arc() {
        this.initArc();
        this.M = new Point();
        this.P = new Point();
        this.k = null;
        this.l = null;
        this.A = null;
        this.R = null;
        this.radius = null;
    }

    public Arc(String string, int n, Point point, Point point2, Point point3, int n2) {
        super(string, n, point2, point, n2);
        this.initArc();
        this.A = point3;
        this.R = null;
        this.radius = null;
    }

    public Vector data() {
        Vector<Point> vector = new Vector<Point>();
        vector.addElement(this.getM());
        vector.addElement(this.getP());
        vector.addElement(this.getA());
        return vector;
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("arc_description"));
    }

    public double distance(Point point, Point point2) {
        return Math.sqrt((point.getScreenX() - point2.getScreenX()) * (point.getScreenX() - point2.getScreenX()) + (point.getScreenY() - point2.getScreenY()) * (point.getScreenY() - point2.getScreenY()));
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            if (this.isFullCircle()) {
                super.draw(graphics2D, jBoardPane);
            } else {
                Element element;
                Point point;
                graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
                double d = this.getDEG(this.getM(), this.getP());
                double d2 = this.getDEG(this.getM(), this.getA());
                double d3 = Math.PI * (d < d2 ? d2 + d : d + d2 - 360.0) / 360.0;
                double d4 = this.getM().userDistance(this.getP());
                double d5 = jBoardPane.user2screenX(0.9 * d4) - jBoardPane.origin.getWidth();
                if (!this.isDraft()) {
                    graphics2D.setColor(this.getFill());
                    graphics2D.fillArc(jBoardPane.round(jBoardPane.user2screenX(this.getM().getUserX() - d4)), jBoardPane.round(jBoardPane.user2screenY(this.getM().getUserY() + d4)), 2 * jBoardPane.round(jBoardPane.user2screenX(d4) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d4) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d), jBoardPane.round(d < d2 ? d2 - d : 360.0 - d + d2));
                    if (this.isMode() && jBoardPane.getModus() != 210260) {
                        graphics2D.setColor(this.getLighting());
                    } else {
                        graphics2D.setColor(this.getStroke());
                    }
                } else {
                    graphics2D.setColor(this.getDraftColor());
                }
                graphics2D.drawArc(jBoardPane.round(jBoardPane.user2screenX(this.getM().getUserX() - d4)), jBoardPane.round(jBoardPane.user2screenY(this.getM().getUserY() + d4)), 2 * jBoardPane.round(jBoardPane.user2screenX(d4) - jBoardPane.origin.getWidth()), Math.abs(jBoardPane.round(2.0 * (jBoardPane.user2screenY(d4) - jBoardPane.user2screenY(0.0)))), jBoardPane.round(d), jBoardPane.round(d < d2 ? d2 - d : 360.0 - d + d2));
                graphics2D.setColor(Color.red);
                if (this.isFirstArrow()) {
                    point = new Point();
                    point.setUser(this.user2circle(new Coordinates(this.getA().getUserX(), this.getA().getUserY())));
                    element = new Point();
                    ((Point)element).setUser(point.getUserX() - (-point.getUserY() + this.getM().getUserY()) / d4, point.getUserY() + (-point.getUserX() + this.getM().getUserX()) / d4);
                    jBoardPane.user2screen(point);
                    jBoardPane.user2screen((Point)element);
                    Arrow arrow = new Arrow("", -1, (Point)element, point, 0);
                    arrow.setStroke(this.getStroke());
                    arrow.drawTop(graphics2D, jBoardPane);
                }
                if (this.isLastArrow()) {
                    point = new Point();
                    point.setUser(this.getP().getUserX() + (-this.getP().getUserY() + this.getM().getUserY()) / d4, this.getP().getUserY() - (-this.getP().getUserX() + this.getM().getUserX()) / d4);
                    jBoardPane.user2screen(point);
                    element = new Arrow("", -1, point, this.getP(), 0);
                    element.setStroke(this.getStroke());
                    ((Arrow)element).drawTop(graphics2D, jBoardPane);
                }
                if (this.isNameDrawed()) {
                    if (!this.isDraft()) {
                        graphics2D.setColor(this.getLabel());
                    } else {
                        graphics2D.setColor(this.getDraftColor());
                    }
                    if (this.isTextName() && this.getNameText() != null) {
                        jBoardPane.drawName(graphics2D, this.getNameText(), jBoardPane.round(this.getM().getScreenX() + Math.cos(d3) * d5), jBoardPane.round(this.getM().getScreenY() - Math.sin(d3) * d5), graphics2D.getColor(), 0, 12);
                    } else {
                        jBoardPane.drawName(graphics2D, this.getName(), jBoardPane.round(this.getM().getScreenX() + Math.cos(d3) * d5), jBoardPane.round(this.getM().getScreenY() - Math.sin(d3) * d5), graphics2D.getColor(), 0, 12);
                    }
                }
            }
        }
    }

    public boolean exists() {
        return this.M.exists() && this.P.exists() && this.A.exists();
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterArc++;
        String string2 = Geonext.language.getString("arc_auto_name");
        while (!bl) {
            while (n > -1) {
                string = "" + (char)(97 + n % 26) + string;
                n = (n - n % 26) / 26 - 1;
            }
            if (elementSet.searchName(string2 + "_" + string) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterArc;
        }
        this.setName(string2 + "_" + string);
    }

    public Point getA() {
        return this.A;
    }

    public void initArc() {
        this.area = 3;
        this.stroke = Color.blue;
        this.fill = new Color(0, 255, 0, 0);
        this.lighting = Color.cyan;
        this.label = new Color(0, 0, 0, 0);
        this.typeString = "arc";
        this.setElementName(Geonext.language.getString("arc_element_name"));
    }

    public boolean isLastarrow() {
        return this.lastArrow;
    }

    public boolean isFirstarrow() {
        return this.firstArrow;
    }

    public boolean isFullcircle() {
        return this.fullCircle;
    }

    public boolean isFullCircle() {
        return this.fullCircle;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d;
        double d2 = Math.sqrt((this.getM().getScreenX() - this.getP().getScreenX()) * (this.getM().getScreenX() - this.getP().getScreenX()) + (this.getM().getScreenY() - this.getP().getScreenY()) * (this.getM().getScreenY() - this.getP().getScreenY()));
        if (d2 - (d = Math.sqrt((this.getM().getScreenX() - (double)mouseEvent.getX()) * (this.getM().getScreenX() - (double)mouseEvent.getX()) + (this.getM().getScreenY() - (double)mouseEvent.getY()) * (this.getM().getScreenY() - (double)mouseEvent.getY()))) < (double)this.area & d - d2 < (double)this.area && this.isVisible()) {
            this.setMode(true);
        } else {
            this.setMode(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            Point point = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "radius")[1]);
            Point point2 = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "angle")[1]);
            Point point3 = (Point)jBoardPane.element.searchLoadID(this.tag(string3, "midpoint")[1]);
            if (point == null || point2 == null || point3 == null || point.equals(point2) || point.equals(point3) || point3.equals(point2)) {
                return false;
            }
            jBoardPane.createArc(point3, point, point2, string2, false);
            Circle circle = (Circle)jBoardPane.element.circle.lastElement();
            string = circle.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String parseProperties(String string) {
        super.parseProperties(string);
        this.setFullcircle(this.tag(string, "full")[1]);
        string = this.tag(string, "full")[0];
        this.setFirstarrow(this.tag(string, "firstarrow")[1]);
        string = this.tag(string, "firstarrow")[0];
        this.setLastarrow(this.tag(string, "lastarrow")[1]);
        string = this.tag(string, "lastarrow")[0];
        return string;
    }

    public void setA(Point point) {
        this.A = point;
    }

    public void setFullcircle(String string) {
        this.setFullCircle(new Boolean(string));
    }

    public void setFullCircle(boolean bl) {
        this.fullCircle = bl;
    }

    public String svg() {
        String string = new String();
        if (this.exists() && this.isVisible()) {
            int n = (int)Math.round(this.getM().getScreenX());
            int n2 = (int)Math.round(this.getM().getScreenY());
            int n3 = (int)Math.round(this.getP().getScreenX());
            int n4 = (int)Math.round(this.getP().getScreenY());
            if (!this.isDraft()) {
                string = string + "<circle cx=\"" + n + "\" cy=\"" + n2 + "\" r=\"" + (int)Math.round(this.distance(this.getM(), this.getP())) + "\" style=\"stroke-width:1; stroke:" + this.rgb2svgrgb(this.getStroke()) + "; fill:" + this.rgb2svgrgb(this.getFill()) + "; stroke-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getFill().getAlpha() / 255.0 + "\" />\n";
                string = string + "<text x=\"" + (this.getM().getScreenX() - (this.getP().getScreenX() - this.getM().getScreenX()) * 0.9) + "\" y=\"" + (this.getM().getScreenY() - (this.getP().getScreenY() - this.getM().getScreenY()) * 0.9) + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
                string = string + this.rgb2svgrgb(this.getLabel());
                string = string + "; fill-opacity:" + (double)this.getLabel().getAlpha() / 255.0;
                string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
                return string;
            }
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 - 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 + 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 + 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 - 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<text x=\"" + n + "\" y=\"" + (n2 - 10) + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
            string = string + this.rgb2svgrgb(this.getDraftColor());
            string = string + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0;
            string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
            return string;
        }
        return string;
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = super.writeData(string);
        string2 = string2 + string + "<angle>" + this.getA().getId() + "</angle>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<full>" + this.isFullCircle() + "</full>\n";
        string2 = string2 + string + "<firstarrow>" + this.isFirstArrow() + "</firstarrow>\n";
        string2 = string2 + string + "<lastarrow>" + this.isLastArrow() + "</lastarrow>\n";
        return string2;
    }

    public String shortInfo() {
        if (this.getParent() != null) {
            return this.getParent().shortInfo();
        }
        return this.generateShort(Geonext.language.getString("arc_short"));
    }

    public boolean isFirstArrow() {
        return this.firstArrow;
    }

    public boolean isLastArrow() {
        return this.lastArrow;
    }

    public void setFirstArrow(boolean bl) {
        this.firstArrow = bl;
    }

    public void setLastArrow(boolean bl) {
        this.lastArrow = bl;
    }

    public void setFirstarrow(String string) {
        this.setFirstArrow(new Boolean(string));
    }

    public void setLastarrow(String string) {
        this.setLastArrow(new Boolean(string));
    }
}

