/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JContentPanel;
import geonext.JListRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentParameterCurve
extends JContentPanel
implements ActionListener {
    public JBoardPane board;
    public JComboBox xInput;
    public JComboBox yInput;
    public JComboBox rangeMinInput;
    public JComboBox rangeMaxInput;

    public JContentParameterCurve() {
    }

    public JContentParameterCurve(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 5));
        jPanel.add(new JLabel("x (t)  ="));
        jPanel.add(new JLabel("y (t)  ="));
        this.xInput = new JComboBox(jBoardPane.pCurveXHistoryString);
        this.xInput.setEditable(true);
        this.xInput.setMaximumRowCount(5);
        this.xInput.setRenderer(new JListRenderer());
        this.xInput.requestFocus();
        this.yInput = new JComboBox(jBoardPane.pCurveYHistoryString);
        this.yInput.setEditable(true);
        this.yInput.setMaximumRowCount(5);
        this.yInput.setRenderer(new JListRenderer());
        this.yInput.requestFocus();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel2.setBorder(new EmptyBorder(15, 0, 15, 15));
        jPanel2.add(this.xInput);
        jPanel2.add(this.yInput);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentparametercurve_term") + " "));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        this.rangeMinInput = new JComboBox(jBoardPane.pCurveMinHistoryString);
        this.rangeMinInput.setEditable(true);
        this.rangeMinInput.setMaximumRowCount(5);
        this.rangeMinInput.setRenderer(new JListRenderer());
        this.rangeMinInput.requestFocus();
        this.rangeMaxInput = new JComboBox(jBoardPane.pCurveMaxHistoryString);
        this.rangeMaxInput.setEditable(true);
        this.rangeMaxInput.setMaximumRowCount(5);
        this.rangeMaxInput.setRenderer(new JListRenderer());
        this.rangeMaxInput.requestFocus();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 3, 15, 15));
        jPanel4.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel4.add(this.rangeMinInput);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel("\u2264   t   \u2264"));
        jPanel4.add(jPanel5);
        jPanel4.add(this.rangeMaxInput);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(15, 15));
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel6.add("North", jPanel4);
        this.add("North", jPanel3);
        this.add("Center", jPanel6);
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            if (this.testInput()) {
                this.board.createParameterCurve((String)this.xInput.getSelectedItem(), (String)this.yInput.getSelectedItem(), (String)this.rangeMinInput.getSelectedItem(), (String)this.rangeMaxInput.getSelectedItem(), "", false);
                if (!this.board.pCurveXHistoryString.contains((String)this.xInput.getSelectedItem())) {
                    this.board.pCurveXHistoryString.addElement((String)this.xInput.getSelectedItem());
                }
                if (!this.board.pCurveYHistoryString.contains((String)this.yInput.getSelectedItem())) {
                    this.board.pCurveYHistoryString.addElement((String)this.yInput.getSelectedItem());
                }
                if (!this.board.pCurveMinHistoryString.contains((String)this.rangeMinInput.getSelectedItem())) {
                    this.board.pCurveMinHistoryString.addElement((String)this.rangeMinInput.getSelectedItem());
                }
                if (!this.board.pCurveMaxHistoryString.contains((String)this.rangeMaxInput.getSelectedItem())) {
                    this.board.pCurveMaxHistoryString.addElement((String)this.rangeMaxInput.getSelectedItem());
                }
            }
            this.reset();
            this.board.getGeonextParameterCurveDialog().dispose();
        } else if (string.equals("apply")) {
            if (this.testInput()) {
                this.board.createParameterCurve((String)this.xInput.getSelectedItem(), (String)this.yInput.getSelectedItem(), (String)this.rangeMinInput.getSelectedItem(), (String)this.rangeMaxInput.getSelectedItem(), "", false);
                if (!this.board.pCurveXHistoryString.contains((String)this.xInput.getSelectedItem())) {
                    this.board.pCurveXHistoryString.addElement((String)this.xInput.getSelectedItem());
                }
                if (!this.board.pCurveYHistoryString.contains((String)this.yInput.getSelectedItem())) {
                    this.board.pCurveYHistoryString.addElement((String)this.yInput.getSelectedItem());
                }
                if (!this.board.pCurveMinHistoryString.contains((String)this.rangeMinInput.getSelectedItem())) {
                    this.board.pCurveMinHistoryString.addElement((String)this.rangeMinInput.getSelectedItem());
                }
                if (!this.board.pCurveMaxHistoryString.contains((String)this.rangeMaxInput.getSelectedItem())) {
                    this.board.pCurveMaxHistoryString.addElement((String)this.rangeMaxInput.getSelectedItem());
                }
                this.reset();
            }
            this.xInput.requestFocus();
        } else if (string.equals("cancel")) {
            this.board.getGeonextParameterCurveDialog().dispose();
        }
        this.board.repaint();
    }

    public void createStartPoint() {
    }

    public void reset() {
        this.xInput.setSelectedItem("");
        this.yInput.setSelectedItem("");
        this.rangeMinInput.setSelectedItem("");
        this.rangeMaxInput.setSelectedItem("");
    }

    public boolean testInput() {
        String string = (String)this.xInput.getSelectedItem();
        String string2 = (String)this.yInput.getSelectedItem();
        C.boardName = this.board.internalName;
        boolean bl = true;
        try {
            C.GEV(new Scanner(string2, false).start());
        }
        catch (Throwable throwable) {
            this.yInput.setForeground(Color.red);
            bl = false;
        }
        try {
            C.GEV(new Scanner(string, false).start());
        }
        catch (Throwable throwable) {
            this.xInput.setForeground(Color.red);
            bl = false;
        }
        return bl;
    }
}

