/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Arc;
import geonext.Arrow;
import geonext.Circle;
import geonext.Coordinates;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.Group;
import geonext.Intersection;
import geonext.JBoardPane;
import geonext.Line;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import util.Base64;
import util.IO;

public class Point
extends Element
implements MouseMotionListener {
    public boolean group;
    public Vector groups;
    public boolean fix;
    public Coordinates user;
    public Coordinates screen;
    public double[] sphere;
    public BufferedImage image;
    public String imageName = "";
    public boolean intersection = false;
    public boolean coordinates;
    public int style = 1;
    public boolean movable = true;

    public Point() {
        this.setChanged(false);
        this.initPoint();
    }

    public Point(String string, int n, int n2) {
        super(string, n, n2);
        this.initPoint();
    }

    public void calculate(boolean bl) {
        this.user2sphere();
    }

    public Vector data() {
        return new Vector();
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("point_description"));
    }

    public void draw(Graphics graphics, int n) {
        int n2 = (int)Math.round(this.screen.getWidth());
        int n3 = (int)Math.round(this.screen.getHeight());
        if (this.getStyle() < 0 && this.getImage() != null) {
            graphics.drawImage(this.getImage(), n2 - this.getImage().getWidth(null) / 2, n3 - this.getImage().getHeight(null) / 2, null);
        } else {
            this.draw(graphics, n2, n3, n);
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                graphics.drawLine(n - 2, n2 - 2, n + 2, n2 + 2);
                graphics.drawLine(n + 2, n2 - 2, n - 2, n2 + 2);
                break;
            }
            case 1: {
                graphics.drawLine(n - 3, n2 - 3, n + 3, n2 + 3);
                graphics.drawLine(n + 3, n2 - 3, n - 3, n2 + 3);
                break;
            }
            case 2: {
                graphics.drawLine(n - 4, n2 - 4, n + 4, n2 + 4);
                graphics.drawLine(n + 4, n2 - 4, n - 4, n2 + 4);
                break;
            }
            case 3: {
                graphics.fillOval(n - 1, n2 - 1, 3, 3);
                break;
            }
            case 4: {
                graphics.fillOval(n - 2, n2 - 2, 5, 5);
                break;
            }
            case 5: {
                graphics.fillOval(n - 3, n2 - 3, 7, 7);
                break;
            }
            case 6: {
                graphics.fillOval(n - 4, n2 - 4, 9, 9);
                break;
            }
            case 7: {
                graphics.fillRect(n - 2, n2 - 2, 5, 5);
                break;
            }
            case 8: {
                graphics.fillRect(n - 3, n2 - 3, 7, 7);
                break;
            }
            case 9: {
                graphics.fillRect(n - 4, n2 - 4, 9, 9);
                break;
            }
            case 10: {
                graphics.drawLine(n - 2, n2, n + 2, n2);
                graphics.drawLine(n, n2 - 2, n, n2 + 2);
                break;
            }
            case 11: {
                graphics.drawLine(n - 3, n2, n + 3, n2);
                graphics.drawLine(n, n2 - 3, n, n2 + 3);
                break;
            }
            case 12: {
                graphics.drawLine(n - 4, n2, n + 4, n2);
                graphics.drawLine(n, n2 - 4, n, n2 + 4);
                break;
            }
            case 20: {
                graphics.drawLine(n - 5, n2 - 5, n - 5, n2 - 3);
                graphics.drawLine(n - 5, n2 - 3, n - 2, n2);
                graphics.drawLine(n - 2, n2, n - 5, n2 + 3);
                graphics.drawLine(n - 5, n2 + 3, n - 5, n2 + 5);
                graphics.drawLine(n - 5, n2 + 5, n - 3, n2 + 5);
                graphics.drawLine(n - 3, n2 + 5, n, n2 + 2);
                graphics.drawLine(n, n2 + 2, n + 3, n2 + 5);
                graphics.drawLine(n + 3, n2 + 5, n + 5, n2 + 5);
                graphics.drawLine(n + 5, n2 + 5, n + 5, n2 + 3);
                graphics.drawLine(n + 5, n2 + 3, n + 2, n2);
                graphics.drawLine(n + 2, n2, n + 5, n2 - 3);
                graphics.drawLine(n + 5, n2 - 3, n + 5, n2 - 5);
                graphics.drawLine(n + 5, n2 - 5, n + 3, n2 - 5);
                graphics.drawLine(n + 3, n2 - 5, n, n2 - 2);
                graphics.drawLine(n, n2 - 2, n - 3, n2 - 5);
                graphics.drawLine(n - 3, n2 - 5, n - 5, n2 - 5);
                break;
            }
        }
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible()) {
            graphics2D.setStroke(jBoardPane.setStroke(this.getStrokeWidth(), this.getDash()));
            if (!this.isDraft()) {
                if (this.isMode()) {
                    switch (jBoardPane.getModus()) {
                        case 76: 
                        case 210240: 
                        case 210250: {
                            graphics2D.setColor(new Line().getLighting());
                            break;
                        }
                        case 210040: {
                            graphics2D.setColor(new Arrow().getLighting());
                            break;
                        }
                        case 67: {
                            graphics2D.setColor(new Circle().getLighting());
                        }
                        case 210020: {
                            graphics2D.setColor(new Arc().getLighting());
                            break;
                        }
                        default: {
                            graphics2D.setColor(this.getLighting());
                            break;
                        }
                    }
                } else {
                    graphics2D.setColor(this.getStroke());
                }
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            this.draw((Graphics)graphics2D, this.getStyle());
            if (this.isNameDrawed() && this.getStyle() > -1) {
                int n = jBoardPane.round(this.getScreenX());
                int n2 = jBoardPane.round(this.getScreenY());
                String string = "";
                if (!this.isDraft()) {
                    switch (this.groups.size()) {
                        case 0: {
                            break;
                        }
                        default: {
                            if (!((Group)this.groups.lastElement()).isVisible()) break;
                            jBoardPane.drawName(graphics2D, "  " + ((Group)this.groups.lastElement()).getName() + "", n, n2 + 15, ((Group)this.groups.lastElement()).getLabel(), 0, 12);
                        }
                    }
                    graphics2D.setColor(this.getLabel());
                } else {
                    graphics2D.setColor(this.getDraftColor());
                }
                if (this.isTextName() && this.getNameText() != null) {
                    jBoardPane.drawName(graphics2D, this.getNameText(), n, n2 - 10, graphics2D.getColor(), 0, 12);
                } else {
                    jBoardPane.drawName(graphics2D, this.getName(), n, n2 - 10, graphics2D.getColor(), 0, 12);
                }
                if (this.isCoordinates()) {
                    string = "  _{(" + jBoardPane.digitString(this.getUserX(), 0, true) + " / " + jBoardPane.digitString(this.getUserY(), 0, true) + ")}";
                }
                jBoardPane.drawName(graphics2D, string, n, n2 - 1, graphics2D.getColor(), 0, 12);
            }
        }
    }

    public void drawTrace(Graphics2D graphics2D, JBoardPane jBoardPane) {
    }

    public boolean exists() {
        return this.isActive();
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterPoint++;
        while (!bl) {
            while (n > -1) {
                string = "" + (char)(65 + n % 26) + string;
                n = (n - n % 26) / 26 - 1;
            }
            if (elementSet.searchName(string) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterPoint;
        }
        this.setName(string);
    }

    public Vector getAncestor() {
        return new Vector();
    }

    public Vector getGroups() {
        return this.groups;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Element getParent() {
        return this.parent;
    }

    public Coordinates getScreen() {
        return this.screen;
    }

    public double getScreenX() {
        return this.screen.getWidth();
    }

    public double getScreenY() {
        return this.screen.getHeight();
    }

    public double[] getSphere() {
        return this.sphere;
    }

    public int getStyle() {
        return this.style;
    }

    public Coordinates getTextAnchor() {
        return this.user;
    }

    public Coordinates getUser() {
        return this.user;
    }

    public double getUserX() {
        return this.user.getWidth();
    }

    public double getUserY() {
        return this.user.getHeight();
    }

    public double getX() {
        return this.user.getWidth();
    }

    public double getY() {
        return this.user.getHeight();
    }

    public void initPoint() {
        this.area = 9;
        this.fix = false;
        this.group = false;
        this.groups = new Vector();
        this.intersection = false;
        this.screen = new Coordinates();
        this.sphere = new double[3];
        this.user = new Coordinates();
        this.stroke = Color.red;
        this.strokeWidth = 3;
        this.lighting = Color.green;
        this.label = Color.black;
        this.typeString = "point";
        this.setElementName(Geonext.language.getString("point_element_name"));
    }

    public boolean inLine(Line line) {
        double d = this.linePos(line);
        return d >= 0.0 && d <= 1.0;
    }

    public boolean isConstructionline() {
        if (this.getParent() instanceof Intersection) {
            return ((Intersection)this.getParent()).isConstructionLine();
        }
        return false;
    }

    public boolean isCoordinates() {
        return this.coordinates;
    }

    public boolean isFix() {
        return this.fix;
    }

    public boolean isGroup() {
        return this.group;
    }

    public boolean isIntersection() {
        return this.intersection;
    }

    public boolean isShow() {
        if (this.getParent() instanceof Intersection) {
            return ((Intersection)this.getParent()).constructionLine;
        }
        return false;
    }

    public double linePos() {
        return 0.0;
    }

    public boolean checkImage(int n, int n2) {
        if (this.image != null && Math.abs(n) < this.image.getWidth() / 2 && Math.abs(n2) < this.image.getHeight() / 2) {
            int n3 = this.image.getRGB(n + this.image.getWidth() / 2, n2 + this.image.getHeight() / 2);
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 & 0xFF;
            int n6 = n3 & 0xFF;
            int n7 = n3 >> 24 & 0xFF;
            if (n7 > 50) {
                return true;
            }
        }
        return false;
    }

    public double linePos(Line line) {
        try {
            double d = 0.0;
            if (Math.round(Math.abs(line.getB().getUserX() - line.getA().getUserX())) != 0L) {
                d = (this.getUserX() - line.getA().getUserX()) / (line.getB().getUserX() - line.getA().getUserX());
            } else if (Math.round(Math.abs(line.getB().getUserY() - line.getA().getUserY())) != 0L) {
                d = (this.getUserY() - line.getA().getUserY()) / (line.getB().getUserY() - line.getA().getUserY());
            }
            return d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.image == null) {
            if (Math.abs((double)mouseEvent.getX() - this.screen.getWidth()) < (double)this.area && Math.abs((double)mouseEvent.getY() - this.screen.getHeight()) < (double)this.area && this.isVisible()) {
                this.setMode(true);
            } else {
                this.setMode(false);
            }
        } else {
            this.setMode(this.checkImage(mouseEvent.getX() - (int)this.screen.getWidth(), mouseEvent.getY() - (int)this.screen.getHeight()));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.image == null) {
            if (Math.abs((double)mouseEvent.getX() - this.screen.getWidth()) < (double)this.area && Math.abs((double)mouseEvent.getY() - this.screen.getHeight()) < (double)this.area && this.isVisible()) {
                this.setMode(true);
            } else {
                this.setMode(false);
            }
        } else {
            this.setMode(this.checkImage(mouseEvent.getX() - (int)this.screen.getWidth(), mouseEvent.getY() - (int)this.screen.getHeight()));
        }
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        try {
            String string2 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string3 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            String string4 = this.tag(string3, "x")[1];
            String string5 = this.tag(string3, "y")[1];
            if (string4.equals("") || string5.equals("")) {
                return false;
            }
            Coordinates coordinates = new Coordinates(Double.parseDouble(string4), Double.parseDouble(string5));
            Coordinates coordinates2 = jBoardPane.user2screen(coordinates);
            jBoardPane.createPoint(coordinates2.getWidth(), coordinates2.getHeight(), string2, false);
            Point point = (Point)jBoardPane.element.point.lastElement();
            point.setUser(coordinates);
            point.setScreen(jBoardPane.user2screen(coordinates));
            point.user2sphere();
            string = point.parseProperties(jBoardPane, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String parseProperties(JBoardPane jBoardPane, String string) {
        super.parseProperties(jBoardPane, string);
        this.setCoordinates(this.tag(string, "showcoord")[1]);
        string = this.tag(string, "showcoord")[0];
        this.setFix(this.tag(string, "fix")[1]);
        string = this.tag(string, "fix")[0];
        boolean bl = false;
        if (this.tag(string, "image")[1].length() > 0) {
            Object object;
            Image image = null;
            try {
                image = jBoardPane.getToolkit().createImage(Base64.decode(this.tag(string, "image")[1]));
                string = this.tag(string, "image")[0];
            }
            catch (Exception exception) {
                this.setImageName(this.tag(string, "image")[1]);
                string = this.tag(string, "image")[0];
                image = jBoardPane.getImage(this.getImageName());
                this.setStyle(-1);
                bl = true;
            }
            if (image != null) {
                object = new MediaTracker(jBoardPane);
                ((MediaTracker)object).addImage(image, 1);
                try {
                    ((MediaTracker)object).waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.image = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                object = this.image.createGraphics();
                ((Graphics)object).drawImage(image, 0, 0, null);
                this.setImageName("intern");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            this.setStyle(this.tag(string, "style")[1]);
        }
        string = this.tag(string, "style")[0];
        return string;
    }

    public void rotate(double d, Point point) {
        double d2 = this.getUserX() - point.getUserX();
        double d3 = this.getUserY() - point.getUserY();
        this.setUserX(point.getUserX() + Math.cos(d) * d2 + Math.sin(d) * d3);
        this.setUserY(point.getUserY() - Math.sin(d) * d2 + Math.cos(d) * d3);
    }

    public double screenDistance(Point point) {
        return Math.sqrt((this.screen.getWidth() - point.getScreenX()) * (this.screen.getWidth() - point.getScreenX()) + (this.screen.getHeight() - point.getScreenY()) * (this.screen.getHeight() - point.getScreenY()));
    }

    public void setConstructionline(String string) {
        if (this.getParent() instanceof Intersection) {
            ((Intersection)this.getParent()).setConstructionLine(new Boolean(string));
        }
    }

    public void setConstructionLine(boolean bl) {
        if (this.getParent() instanceof Intersection) {
            ((Intersection)this.getParent()).setConstructionLine(bl);
        }
    }

    public void setCoordinates(String string) {
        this.setCoordinates(new Boolean(string));
    }

    public void setCoordinates(boolean bl) {
        this.coordinates = bl;
    }

    public void setFix(String string) {
        this.setFix(new Boolean(string));
    }

    public void setFix(boolean bl) {
        this.fix = bl;
    }

    public void setGroup(boolean bl) {
        this.group = bl;
    }

    public void setGroups(Vector vector) {
        this.groups = vector;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setIntersection(boolean bl) {
        this.intersection = bl;
    }

    public void setParent(Element element) {
        this.parent = element;
    }

    public void setScreen(double d, double d2) {
        this.screen.setSize(d, d2);
    }

    public void setScreen(Coordinates coordinates) {
        this.screen = coordinates;
    }

    public void setScreenX(double d) {
        this.screen.setSize(d, this.screen.getHeight());
    }

    public void setScreenY(double d) {
        this.screen.setSize(this.screen.getWidth(), d);
    }

    public void setSphere(double[] dArray) {
        this.sphere = dArray;
    }

    public void setSphere(double d, double d2, double d3) {
        this.sphere[0] = d;
        this.sphere[1] = d2;
        this.sphere[2] = d3;
    }

    public void setStyle(int n) {
        if (n > 12) {
            n = 12;
        }
        this.style = n;
    }

    public void setStyle(String string) {
        try {
            double d = new Double(string);
            if (d != -1.0) {
                this.setStyle(new Double(Math.abs(new Double(string))).intValue());
            } else if (this.image != null) {
                this.setStyle(-1);
            } else {
                this.setStyle(1);
            }
        }
        catch (Exception exception) {
            this.setStyle(1);
        }
    }

    public void setUser(double[] dArray) {
        this.setUserX(dArray[0]);
        this.setUserY(dArray[1]);
    }

    public void setUser(double d, double d2) {
        this.user.setSize(d, d2);
    }

    public void setUser(Coordinates coordinates) {
        this.user = coordinates;
    }

    public void setUserX(double d) {
        this.user.setSize(d, this.user.getHeight());
    }

    public void setUserY(double d) {
        this.user.setSize(this.user.getWidth(), d);
    }

    public void setX(String string) {
        try {
            this.setUserX(new Double(string));
        }
        catch (Exception exception) {
            this.setUserX(0.0);
        }
    }

    public void setY(String string) {
        try {
            this.setUserY(new Double(string));
        }
        catch (Exception exception) {
            this.setUserY(0.0);
        }
    }

    public void sphere2user() {
        this.user.setSize(this.sphere[0] * 100.0 / this.sphere[2], this.sphere[1] * 100.0 / this.sphere[2]);
    }

    public String svg() {
        String string = new String();
        if (this.exists() && this.isVisible()) {
            int n = (int)Math.round(this.getScreenX());
            int n2 = (int)Math.round(this.getScreenY());
            if (!this.isDraft()) {
                string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 - 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 + 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getStroke()) + "; fill:" + this.rgb2svgrgb(this.getStroke()) + "; stroke-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "\" />\n";
                string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 + 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 - 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getStroke()) + "; fill:" + this.rgb2svgrgb(this.getStroke()) + "; stroke-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getStroke().getAlpha() / 255.0 + "\" />\n";
                string = string + "<text x=\"" + n + "\" y=\"" + (n2 - 10) + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
                string = string + this.rgb2svgrgb(this.getLabel());
                string = string + "; fill-opacity:" + (double)this.getLabel().getAlpha() / 255.0;
                string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
                return string;
            }
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 - 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 + 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<line x1=\"" + (n - 3) + "\" y1=\"" + (n2 + 3) + "\" x2=\"" + (n + 3) + "\" y2=\"" + (n2 - 3) + "\" style=\"stroke-width:2; stroke:" + this.rgb2svgrgb(this.getDraftColor()) + "; fill:" + this.rgb2svgrgb(this.getDraftColor()) + "; stroke-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0 + "\" />\n";
            string = string + "<text x=\"" + n + "\" y=\"" + (n2 - 10) + "\" style=\"font-family: Arial; font-size: 12 pt; fill:";
            string = string + this.rgb2svgrgb(this.getDraftColor());
            string = string + "; fill-opacity:" + (double)this.getDraftColor().getAlpha() / 255.0;
            string = string + "\">" + this.generateSVGName(this.getName(), 12) + "</text>\n";
            return string;
        }
        return string;
    }

    public String toString() {
        return super.toString();
    }

    public void user2sphere() {
        double d = this.user.getWidth();
        double d2 = this.user.getHeight();
        double d3 = Math.sqrt(d * d + d2 * d2 + 10000.0);
        this.sphere[0] = d / d3;
        this.sphere[1] = d2 / d3;
        this.sphere[2] = 100.0 / d3;
    }

    public double[] user2sphere(double d, double d2) {
        double d3 = Math.sqrt(d * d + d2 * d2 + 10000.0);
        double[] dArray = new double[]{d / d3, d2 / d3, 100.0 / d3};
        return dArray;
    }

    public double[] user2sphere(Dimension dimension) {
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        double d3 = Math.sqrt(d * d + d2 * d2 + 10000.0);
        double[] dArray = new double[]{d / d3, d2 / d3, 100.0 / d3};
        return dArray;
    }

    public double userDistance(Point point) {
        return Math.sqrt((this.user.getWidth() - point.getUserX()) * (this.user.getWidth() - point.getUserX()) + (this.user.getHeight() - point.getUserY()) * (this.user.getHeight() - point.getUserY()));
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<x>" + this.getUserX() + "</x>\n ";
        string2 = string2 + string + "<y>" + this.getUserY() + "</y>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<showcoord>" + this.isCoordinates() + "</showcoord>\n";
        string2 = string2 + string + "<fix>" + this.isFix() + "</fix>\n";
        string2 = string2 + string + "<image>";
        if (this.getImage() != null && this.getStyle() == -1) {
            string2 = string2 + Base64.encodeBytes(IO.image2byteArray(this.getImage()));
        }
        string2 = string2 + "</image>\n";
        if (this.getParent() instanceof Intersection) {
            string2 = string2 + string + "<showconstruction>" + ((Intersection)this.getParent()).isConstructionLine() + "</showconstruction>\n";
        }
        string2 = string2 + string + "<style>" + this.getStyle() + "</style>\n";
        return string2;
    }

    public String[] getAlgebraic() {
        return new String[]{this.name + ".x", this.name + ".y"};
    }

    public String shortInfo() {
        if (this.getParent() != null) {
            return this.getParent().shortInfo();
        }
        return this.generateShort(Geonext.language.getString("point_short"));
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImagename() {
        return this.imageName;
    }

    public void setImageName(String string) {
        this.imageName = string;
    }

    public void setImagename(String string) {
        this.imageName = string;
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean bl) {
        this.movable = bl;
    }
}

