/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.expression.HObject;
import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Coordinates;
import geonext.DrawText;
import geonext.Element;
import geonext.ElementSet;
import geonext.Geonext;
import geonext.JBoardPane;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Locale;
import java.util.Vector;

public class Text
extends Element
implements MouseListener,
MouseMotionListener {
    public String text;
    public Coordinates user;
    public Coordinates screen;
    public Coordinates size;
    public Element e;
    public Vector content;
    public Vector values;
    public static final int ARC = 0;
    public static final int VALUE = 1;
    public static final int NAME = 3;
    public static final int TERM = 4;
    public static final int OVERLINE = 5;
    public static final int ARROW = 6;
    public static final int CAS = 7;
    public static final int TEXT = 8;
    public static final int SQRT = 9;
    public Vector tags;
    public String[] buttonTags = new String[]{"value", "term", "cas", "name", "arc", "overline", "arrow"};
    public int topHeight;
    public int bottomHeight;
    public boolean autoDigits = true;
    public int digits = 2;
    public boolean condition;
    public String condString;
    public int ulWidth = 0;
    public int lrHeight = 0;
    public int ulHeight = 0;
    public int lrWidth = 0;
    public Vector tagList;
    public String javaScriptFunction = "";
    public boolean fix;

    public Text() {
        this.initText();
    }

    public Text(String string, int n, int n2) {
        super(string, n, n2);
        this.text = "";
        this.initText();
    }

    public Text(String string, int n, String string2, int n2) {
        super(string, n, n2);
        this.e = null;
        this.text = string2;
        this.initText();
    }

    public Vector data() {
        return new Vector();
    }

    public String description() {
        return this.generateDesc(Geonext.language.getString("text_description"));
    }

    public void draw(Graphics graphics, int n, int n2, JBoardPane jBoardPane, int n3, int n4) {
        n4 += jBoardPane.fontSize;
        this.ulWidth = n;
        this.ulHeight = n2;
        this.lrWidth = 0;
        this.lrHeight = 0;
        if (this.content != null) {
            C.boardName = jBoardPane.internalName;
            if (!this.isDraft()) {
                graphics.setColor(this.getLabel());
            } else {
                graphics.setColor(this.getDraftColor());
            }
            Font font = graphics.getFont();
            int n5 = 0;
            int n6 = graphics.getFontMetrics().getHeight();
            int n7 = n2;
            String string = "";
            for (int i = 0; i < this.content.size(); ++i) {
                string = (String)this.values.get(i);
                string = new JBoardPane().changeChar(string);
                DrawText drawText = new DrawText(string);
                drawText.getSize(graphics, 0, n4);
                this.ulHeight = Math.min(this.ulHeight, n2 + drawText.getMin());
                this.lrHeight = Math.max((int)drawText.getSize(graphics, 0, n4).getHeight(), this.lrHeight);
                if (((String)this.tags.get(i)).equals("arc")) {
                    graphics.drawLine(n + n5, n2 - 4 - jBoardPane.fontSize / 2, n + jBoardPane.fontSize + n5 + 7, n2 - 8 - jBoardPane.fontSize);
                    graphics.drawLine(n + n5, n2 - 4 - jBoardPane.fontSize / 2, n + jBoardPane.fontSize + n5 + 7, n2);
                    graphics.drawArc(n, n2 - 6 - jBoardPane.fontSize, 4 + jBoardPane.fontSize, 4 + jBoardPane.fontSize, -45, 90);
                    n += 10 + jBoardPane.fontSize;
                }
                if (((String)this.tags.get(i)).equals("overline")) {
                    graphics.drawLine(n, n2 + drawText.getMin(), n + (int)drawText.getSize(graphics, 0, n4).getWidth(), n2 + drawText.getMin());
                } else if (((String)this.tags.get(i)).equals("arrow")) {
                    graphics.drawLine(n, n2 + drawText.getMin(), n + (int)drawText.getSize(graphics, 0, n4).getWidth(), n2 + drawText.getMin());
                    graphics.drawLine(n + (int)drawText.getSize(graphics, 0, n4).getWidth() - 2, n2 + drawText.getMin() + 2, n + (int)drawText.getSize(graphics, 0, n4).getWidth(), n2 + drawText.getMin());
                    graphics.drawLine(n + (int)drawText.getSize(graphics, 0, n4).getWidth() - 2, n2 + drawText.getMin() + -2, n + (int)drawText.getSize(graphics, 0, n4).getWidth(), n2 + drawText.getMin());
                } else if (((String)this.tags.get(i)).equals("sqrt")) {
                    graphics.drawLine(n, n2 - 3, n + 1, n2 - 3);
                    graphics.drawLine(n + 1, n2 - 3, n + 4, n2);
                    graphics.drawLine(n + 4, n2, n + 4, n2 + drawText.getMin());
                    graphics.drawLine((n += 7) - 2, n2 + drawText.getMin(), n + (int)drawText.getSize(graphics, 0, n4).getWidth(), n2 + drawText.getMin());
                }
                drawText.draw(graphics, n, n2, n3, n4);
                n += (int)drawText.getSize(graphics, 0, n4).getWidth();
                graphics.setFont(new Font(font.getName(), font.getStyle(), n4));
            }
            if (!this.isDraft()) {
                if (this.isMode()) {
                    graphics.setColor(this.getLighting());
                } else {
                    graphics.setColor(this.getStroke());
                }
            } else {
                graphics.setColor(this.getDraftColor());
            }
            if (this.getE() != null) {
                graphics.drawLine(this.ulWidth - 2, n2, jBoardPane.round(jBoardPane.user2screen(this.getE().getTextAnchor()).getWidth()), jBoardPane.round(jBoardPane.user2screen(this.getE().getTextAnchor()).getHeight()));
            }
            this.lrWidth = n;
            graphics.drawRect(this.ulWidth - 2, this.ulHeight - 2, this.lrWidth - this.ulWidth + 2, this.lrHeight + 2);
        }
    }

    public void draw(Graphics2D graphics2D, JBoardPane jBoardPane) {
        if (this.exists() && this.isVisible() && this.getJavaScriptFunction().equals("")) {
            graphics2D.setStroke(jBoardPane.setStroke(1, 0));
            this.setScreen(jBoardPane.user2screen(this.getUser()));
            double d = this.getScreen().getWidth();
            double d2 = this.getScreen().getHeight();
            if (this.getE() instanceof Element) {
                this.setScreen(new Coordinates(d += jBoardPane.user2screen(this.getE().getTextAnchor()).getWidth() - jBoardPane.origin.getWidth(), d2 += jBoardPane.user2screen(this.getE().getTextAnchor()).getHeight() - jBoardPane.origin.getHeight()));
            }
            this.setSize(new Coordinates(graphics2D.getFontMetrics().stringWidth(this.getText()) + 10, graphics2D.getFontMetrics().getHeight() + 5));
            graphics2D.setColor(this.getFill());
            if (!this.isDraft()) {
                if (this.isMode()) {
                    graphics2D.setColor(this.getLighting());
                } else {
                    graphics2D.setColor(this.getStroke());
                }
            } else {
                graphics2D.setColor(this.getDraftColor());
            }
            graphics2D.setColor(this.getLabel());
            this.draw(graphics2D, jBoardPane.round(this.getScreen().getWidth()), jBoardPane.round(this.getScreen().getHeight()), jBoardPane, 0, 12);
        }
    }

    public void evaluate(JBoardPane jBoardPane) {
        this.values = new Vector();
        C.boardName = jBoardPane.internalName;
        if (this.content != null) {
            for (int i = 0; i < this.content.size(); ++i) {
                if (((String)this.tags.get(i)).equals("text")) {
                    this.values.addElement((String)this.content.get(i));
                    continue;
                }
                if (((String)this.tags.get(i)).equals("value")) {
                    try {
                        try {
                            double d = Double.parseDouble(C.NEV((HObject)this.content.get(i)).toString());
                            if (this.isAutoDigits()) {
                                this.values.addElement("" + jBoardPane.digitString(d, 0, true));
                                continue;
                            }
                            this.values.addElement("" + jBoardPane.digitString(d, this.getDigits(), false));
                        }
                        catch (Exception exception) {
                            this.values.addElement(C.NEV((HObject)this.content.get(i)).toString());
                        }
                    }
                    catch (Exception exception) {
                        this.values.addElement("<" + Geonext.language.getString("text_error") + ">");
                    }
                    continue;
                }
                if (((String)this.tags.get(i)).equals("cas")) {
                    try {
                        this.values.addElement(this.content.get(i).toString());
                    }
                    catch (Exception exception) {
                        this.values.addElement("<" + Geonext.language.getString("text_error") + ">");
                    }
                    continue;
                }
                if (((String)this.tags.get(i)).equals("name")) {
                    try {
                        this.values.addElement(((Element)this.content.get(i)).getName());
                    }
                    catch (Exception exception) {
                        this.values.addElement("<" + Geonext.language.getString("text_error") + ">");
                    }
                    continue;
                }
                if (((String)this.tags.get(i)).equals("arc")) {
                    this.values.addElement(this.content.get(i));
                    continue;
                }
                if (((String)this.tags.get(i)).equals("overline")) {
                    this.values.addElement(this.content.get(i));
                    continue;
                }
                if (((String)this.tags.get(i)).equals("arrow")) {
                    this.values.addElement(this.content.get(i));
                    continue;
                }
                if (((String)this.tags.get(i)).equals("sqrt")) {
                    this.values.addElement(this.content.get(i));
                    continue;
                }
                this.values.addElement("");
            }
        }
    }

    public boolean exists() {
        return true;
    }

    public void generateName(ElementSet elementSet) {
        boolean bl = false;
        String string = "";
        int n = elementSet.nameCounterText++;
        String string2 = "T";
        while (!bl) {
            if (elementSet.searchName(string2 + "" + n) == null) {
                bl = true;
                continue;
            }
            string = "";
            ++elementSet.nameCounterText;
        }
        this.setName(string2 + "" + n);
    }

    public int getBottomHeight() {
        return this.bottomHeight;
    }

    public String getCondString() {
        return this.condString;
    }

    public Element getE() {
        return this.e;
    }

    public String getJavascriptfunction() {
        return this.javaScriptFunction;
    }

    public String getJavaScriptFunction() {
        return this.javaScriptFunction;
    }

    public Coordinates getScreen() {
        return this.screen;
    }

    public Coordinates getSize() {
        return this.size;
    }

    public String getText() {
        String string = "";
        if (this.content != null) {
            for (int i = 0; i < this.content.size(); ++i) {
                string = this.tags.get(i).equals("text") ? string + "" + this.content.get(i) : (this.tags.get(i).equals("arc") ? string + "<" + this.tags.get(i) + ">" + this.content.get(i) : (this.tags.get(i).equals("name") ? string + "<" + this.tags.get(i) + ">" + ((Element)this.content.get(i)).getName() + "</" + this.tags.get(i) + ">" : string + "<" + this.tags.get(i) + ">" + this.content.get(i) + "</" + this.tags.get(i) + ">"));
            }
        } else {
            string = string + this.text;
        }
        if (string == "") {
            string = this.text;
        }
        return string;
    }

    public String getTextValue() {
        String string = "";
        if (this.content != null) {
            for (int i = 0; i < this.content.size(); ++i) {
                string = this.tags.get(i).equals("value") ? string + "<value>" + this.values.get(i) + "</value>" : (this.tags.get(i).equals("text") ? string + "" + this.content.get(i) : (this.tags.get(i).equals("arc") ? string + "<" + this.tags.get(i) + ">" + this.content.get(i) : (this.tags.get(i).equals("name") ? string + "<" + this.tags.get(i) + ">" + ((Element)this.content.get(i)).getName() + "</" + this.tags.get(i) + ">" : string + "<" + this.tags.get(i) + ">" + this.content.get(i) + "</" + this.tags.get(i) + ">")));
            }
        } else {
            string = string + this.text;
        }
        if (string == "") {
            string = this.text;
        }
        return string;
    }

    public Coordinates getTextAnchor() {
        Coordinates coordinates = this.getE() != null ? new Coordinates(this.user.getWidth() + this.getE().getTextAnchor().getWidth(), this.user.getHeight() + this.getE().getTextAnchor().getHeight()) : this.user;
        return coordinates;
    }

    public int getTopHeight() {
        return this.topHeight;
    }

    public Coordinates getUser() {
        return this.user;
    }

    public void initTagList() {
        this.tagList = new Vector();
        this.tagList.addElement("overline");
        this.tagList.addElement("arrow");
        this.tagList.addElement("arc");
        this.tagList.addElement("value");
        this.tagList.addElement("sqrt");
        this.tagList.addElement("name");
    }

    public void initText() {
        this.e = null;
        this.screen = new Coordinates(0.0, 0.0);
        this.user = new Coordinates(0.0, 0.0);
        this.size = new Coordinates(0.0, 0.0);
        this.setStroke(new Color(200, 200, 200, 0));
        this.setLighting(new Color(100, 100, 100));
        this.setFill(new Color(100, 100, 100, 0));
        this.initTagList();
        this.typeString = "text";
        this.setElementName(Geonext.language.getString("text_element_name"));
    }

    public boolean isCondition() {
        return this.condition;
    }

    public boolean isFix() {
        return this.fix;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getX() > this.ulWidth && mouseEvent.getY() < this.ulHeight + this.lrHeight && mouseEvent.getX() < this.lrWidth && mouseEvent.getY() > this.ulHeight && this.isVisible()) {
            this.setMode(true);
        } else {
            this.setMode(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getX() > this.ulWidth && mouseEvent.getY() < this.ulHeight + this.lrHeight && mouseEvent.getX() < this.lrWidth && mouseEvent.getY() > this.ulHeight && this.isVisible()) {
            this.setMode(true);
        } else {
            this.setMode(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean parse(JBoardPane jBoardPane, String string) {
        String string2 = "<id>oldVersion";
        int n = string.indexOf(string2);
        if (n > -1) {
            try {
                Double d = new Double(string.substring(n + string2.length(), string.indexOf("</id>")));
                Double d2 = new Double("1.71");
                if (d <= d2) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            String string3 = this.tag(string, "name")[1];
            string = this.tag(string, "name")[0];
            String string4 = this.tag(string, "data")[1];
            string = this.tag(string, "data")[0];
            String string5 = this.tag(string4, "x")[1];
            String string6 = this.tag(string4, "y")[1];
            String string7 = this.tag(string4, "parent")[1];
            String string8 = this.tag(string4, "content")[1];
            Element element = jBoardPane.element.searchLoadID(string7);
            if (string8.equals("") || string5.equals("") || string6.equals("")) {
                return false;
            }
            Coordinates coordinates = new Coordinates(Double.parseDouble(string5), Double.parseDouble(string6));
            jBoardPane.createText(coordinates.getWidth(), coordinates.getHeight(), string8, element);
            Text text = (Text)jBoardPane.element.text.lastElement();
            text.setName(string3);
            string = text.parseProperties(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void parseHTML(JBoardPane jBoardPane) {
        try {
            this.content = new Vector();
            this.tags = new Vector();
            this.values = new Vector();
            String string = this.getText();
            C.boardName = jBoardPane.internalName;
            while (string.toLowerCase(new Locale("en")).indexOf("</arc>") > -1) {
                string = string.substring(0, string.toLowerCase(new Locale("en")).indexOf("</arc>")) + string.substring(string.toLowerCase(new Locale("en")).indexOf("</arc>") + 6, string.length());
            }
            while (!string.equals("")) {
                int n = string.indexOf("<");
                if (n > -1) {
                    this.content.addElement(string.substring(0, n));
                    this.tags.addElement("text");
                    string = string.substring(n, string.length());
                    int n2 = string.substring(0, string.length()).indexOf(">");
                    if (n2 > -1) {
                        String string2 = string.toLowerCase(new Locale("en")).substring(1, n2);
                        if (this.tagList.contains(string2.toLowerCase(new Locale("en")))) {
                            if (string2.equals("arc")) {
                                this.content.addElement("");
                                this.tags.addElement(string2);
                                string = jBoardPane.parse(string, string2)[0];
                                continue;
                            }
                            if (string.toLowerCase(new Locale("en")).indexOf("</" + string2 + ">") > -1) {
                                switch (this.tagValue(string2)) {
                                    case 7: {
                                        Scanner scanner;
                                        try {
                                            scanner = new Scanner(jBoardPane.parse(string, string2)[1], false);
                                            this.content.addElement(scanner.start());
                                            this.tags.addElement("cas");
                                        }
                                        catch (Exception exception) {}
                                        break;
                                    }
                                    case 3: {
                                        try {
                                            Element element = jBoardPane.element.searchName(jBoardPane.parse(string, string2)[1]);
                                            if (element == null) break;
                                            this.content.addElement(element);
                                            this.tags.addElement("name");
                                        }
                                        catch (Exception exception) {}
                                        break;
                                    }
                                    case 4: {
                                        Scanner scanner;
                                        try {
                                            scanner = new Scanner(jBoardPane.parse(string, string2)[1], false);
                                            this.content.addElement(scanner.start());
                                            this.tags.addElement("cas");
                                            this.content.addElement(" = ");
                                            this.tags.addElement("text");
                                            scanner = new Scanner(jBoardPane.parse(string, string2)[1], false);
                                            this.content.addElement(scanner.start());
                                            this.tags.addElement("value");
                                        }
                                        catch (Exception exception) {}
                                        break;
                                    }
                                    case 1: {
                                        Scanner scanner;
                                        try {
                                            scanner = new Scanner(jBoardPane.parse(string, string2)[1], false);
                                            this.content.addElement(scanner.start());
                                            this.tags.addElement("value");
                                        }
                                        catch (Exception exception) {
                                            if (string.toLowerCase(new Locale("en")).indexOf("</" + string2 + ">") > -1) {
                                                this.content.addElement(jBoardPane.parse(string, string2)[1]);
                                                this.tags.addElement(string2);
                                                string = jBoardPane.parse(string, string2)[0];
                                                break;
                                            }
                                            string = string.substring(2 + string2.length(), string.length());
                                        }
                                        break;
                                    }
                                    default: {
                                        this.content.addElement(jBoardPane.parse(string, string2)[1]);
                                        this.tags.addElement(string2);
                                    }
                                }
                                string = jBoardPane.parse(string, string2)[0];
                                continue;
                            }
                            string = string.substring(2 + string2.length(), string.length());
                            continue;
                        }
                        this.content.addElement(string.substring(0, n2 + 1));
                        this.tags.addElement("text");
                        string = string.substring(n2 + 1, string.length());
                        continue;
                    }
                    this.content.addElement(string);
                    this.tags.addElement("text");
                    string = "";
                    continue;
                }
                this.content.addElement(string);
                this.tags.addElement("text");
                string = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String parseProperties(String string) {
        super.parseProperties(string);
        this.setJsf(this.tag(string, "jsf")[1]);
        string = this.tag(string, "jsf")[0];
        this.setCondition(this.tag(string, "condition")[1]);
        string = this.tag(string, "condition")[0];
        this.setCs(this.tag(string, "cs")[1]);
        string = this.tag(string, "cs")[0];
        this.setFix(this.tag(string, "fix")[1]);
        string = this.tag(string, "fix")[0];
        this.setDigits(this.tag(string, "digits")[1]);
        string = this.tag(string, "digits")[0];
        this.setAutodigits(this.tag(string, "autodigits")[1]);
        string = this.tag(string, "autodigits")[0];
        return string;
    }

    public void setBottomHeight(int n) {
        this.bottomHeight = n;
    }

    public void setCondition(String string) {
        this.setCondition(new Boolean(string));
    }

    public void setCondition(boolean bl) {
        this.condition = bl;
    }

    public void setCondString(String string) {
        this.condString = string;
    }

    public void setCs(String string) {
        this.condString = string;
    }

    public void setE(Element element) {
        this.e = element;
    }

    public void setAutodigits(String string) {
        this.setAutoDigits(new Boolean(string));
    }

    public void setFix(String string) {
        this.setFix(new Boolean(string));
    }

    public void setFix(boolean bl) {
        this.fix = bl;
    }

    public void setJavaScriptFunction(String string) {
        this.javaScriptFunction = string;
    }

    public void setJsf(String string) {
        this.javaScriptFunction = string;
    }

    public void setScreen(double d, double d2) {
        this.screen.setSize(d, d2);
    }

    public void setScreen(Coordinates coordinates) {
        this.screen = coordinates;
    }

    public void setSize(Coordinates coordinates) {
        this.size = coordinates;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTopHeight(int n) {
        this.topHeight = n;
    }

    public void setUser(Coordinates coordinates) {
        this.user = coordinates;
    }

    public void setX(String string) {
        try {
            this.user.setWidth(new Double(string));
        }
        catch (Exception exception) {
            this.user.setWidth(0.0);
        }
    }

    public void setY(String string) {
        try {
            this.user.setHeight(new Double(string));
        }
        catch (Exception exception) {
            this.user.setHeight(0.0);
        }
    }

    public int tagValue(String string) {
        if ((string = string.toLowerCase(new Locale("en"))).equals("text")) {
            return 8;
        }
        if (string.equals("arc")) {
            return 0;
        }
        if (string.equals("arrow")) {
            return 6;
        }
        if (string.equals("cas")) {
            return 7;
        }
        if (string.equals("name")) {
            return 3;
        }
        if (string.equals("term")) {
            return 4;
        }
        if (string.equals("overline")) {
            return 5;
        }
        if (string.equals("value")) {
            return 1;
        }
        if (string.equals("sqrt")) {
            return 9;
        }
        return -1;
    }

    public String writeData(String string) {
        String string2 = "";
        string2 = string2 + string + "<content>" + this.getText() + "</content>\n ";
        String string3 = this.getText();
        while (string3.toLowerCase(new Locale("en")).indexOf("<arc>") > -1) {
            string3 = string3.substring(0, string3.toLowerCase(new Locale("en")).indexOf("<arc>")) + "&arc;" + string3.substring(string3.toLowerCase(new Locale("en")).indexOf("<arc>") + 5, string3.length());
        }
        string2 = string2 + string + "<mp>" + string3 + "</mp>\n ";
        string3 = this.getTextValue();
        while (string3.toLowerCase(new Locale("en")).indexOf("<arc>") > -1) {
            string3 = string3.substring(0, string3.toLowerCase(new Locale("en")).indexOf("<arc>")) + "&arc;" + string3.substring(string3.toLowerCase(new Locale("en")).indexOf("<arc>") + 5, string3.length());
        }
        string2 = string2 + string + "<mpx>" + string3 + "</mpx>\n ";
        string2 = string2 + string + "<x>" + this.getUser().getWidth() + "</x>\n ";
        string2 = string2 + string + "<y>" + this.getUser().getHeight() + "</y>\n ";
        string2 = this.getE() == null ? string2 + string + "<parent></parent>\n " : string2 + string + "<parent>" + this.getE().getId() + "</parent>\n ";
        return string2;
    }

    public String writeProperties(String string) {
        String string2 = "";
        string2 = string2 + super.writeProperties(string);
        string2 = string2 + string + "<condition>" + this.isCondition() + "</condition>\n ";
        string2 = string2 + string + "<cs>" + this.getCondString() + "</cs>\n ";
        string2 = string2 + string + "<jsf>" + this.getJavaScriptFunction() + "</jsf>\n ";
        string2 = string2 + string + "<fix>" + this.isFix() + "</fix>\n ";
        string2 = string2 + string + "<digits>" + this.getDigits() + "</digits>\n ";
        string2 = string2 + string + "<autodigits>" + this.isAutoDigits() + "</autodigits>\n ";
        return string2;
    }

    public String shortInfo() {
        return this.getText();
    }

    public boolean isAutoDigits() {
        return this.autoDigits;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setAutoDigits(boolean bl) {
        this.autoDigits = bl;
    }

    public void setDigits(int n) {
        if (n > 18) {
            n = 18;
        }
        this.digits = n;
    }

    public void setDigits(String string) {
        try {
            this.setDigits(new Double(Math.abs(new Double(string))).intValue());
        }
        catch (Exception exception) {
            this.setDigits(2);
        }
    }
}

