/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    int horizontalAlign = 1;
    private static final long serialVersionUID = -7262534875583282631L;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int n) {
        this(n, 5, 5);
    }

    public VerticalFlowLayout(int n, int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
        this.setAlignment(n);
    }

    public VerticalFlowLayout(int n, int n2, int n3, int n4) {
        this.hgap = n3;
        this.vgap = n4;
        this.horizontalAlign = n2;
        this.setAlignment(n);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getHeight() - (insets.top + insets.bottom + this.vgap * 2);
            int n2 = container.getComponentCount();
            int n3 = insets.left + this.hgap;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = container.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                if (n4 == 0 || n4 + dimension.height <= n) {
                    if (n4 > 0) {
                        n4 += this.vgap;
                    }
                    n4 += dimension.height;
                    n5 = Math.max(n5, dimension.width);
                    continue;
                }
                this.moveComponents(container, n3, insets.top + this.vgap, n5, n - n4, n6, i, bl);
                n4 = dimension.height;
                n3 += this.hgap + n5;
                n5 = dimension.width;
                n6 = i;
            }
            this.moveComponents(container, n3, insets.top + this.vgap, n5, n - n4, n6, n2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (i > 0) {
                    dimension.height += this.vgap;
                }
                dimension.height += dimension2.height;
            }
            Insets insets = container.getInsets();
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            dimension.width += insets.left + insets.right + this.hgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    n2 += bl ? 0 : n4;
                    break;
                }
                case 1: {
                    n2 += n4 / 2;
                    break;
                }
                case 2: {
                    n2 += bl ? n4 : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n2 += n4;
                }
            }
            for (int i = n5; i < n6; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (this.horizontalAlign != 0) {
                    if (bl) {
                        component.setLocation(n + (n3 - component.getWidth()) / 2, n2);
                    } else {
                        component.setLocation(n + (n3 - component.getWidth()) / 2, container.getHeight() - n2 - component.getHeight());
                    }
                    n2 += component.getHeight() + this.vgap;
                    continue;
                }
                if (bl) {
                    component.setLocation(n, n2);
                } else {
                    component.setLocation(n, container.getHeight() - n2 - component.getHeight());
                }
                n2 += component.getHeight() + this.vgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (i > 0) {
                    dimension.height += this.vgap;
                }
                dimension.height += dimension2.height;
            }
            Insets insets = container.getInsets();
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            dimension.width += insets.left + insets.right + this.hgap * 2;
            return dimension;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setAlignment(int n) {
        this.newAlign = n;
        switch (n) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = n;
            }
        }
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=top";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=bottom";
                break;
            }
            case 3: {
                string = ",align=leading";
                break;
            }
            case 4: {
                string = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

