/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.DefaultProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.FilteredSubsample;
import org.geotools.coverage.processing.operation.Interpolate;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.Scale;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridRange;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wcs.WcsException;

public class WCSUtils {
    private static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.util");
    private static final SelectSampleDimension bandSelectFactory = new SelectSampleDimension();
    private static final Crop cropFactory = new Crop();
    private static final Interpolate interpolateFactory = new Interpolate();
    private static final Scale scaleFactory = new Scale();
    private static final FilteredSubsample filteredSubsampleFactory = new FilteredSubsample();
    private static final Resample resampleFactory = new Resample();
    private static final ParameterValueGroup bandSelectParams;
    private static final ParameterValueGroup cropParams;
    private static final ParameterValueGroup interpolateParams;
    private static final ParameterValueGroup resampleParams;
    private static final ParameterValueGroup scaleParams;
    private static final ParameterValueGroup filteredSubsampleParams;
    private static final Hints hints;

    public static GridCoverage2D reproject(GridCoverage2D coverage, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Interpolation interpolation) throws WcsException {
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS)) {
            ParameterValueGroup param = resampleParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("CoordinateReferenceSystem").setValue((Object)targetCRS);
            param.parameter("GridGeometry").setValue(null);
            param.parameter("InterpolationType").setValue((Object)interpolation);
            coverage = (GridCoverage2D)resampleFactory.doOperation(param, hints);
        }
        return coverage;
    }

    public static GridCoverage2D interpolate(GridCoverage2D coverage, Interpolation interpolation) throws WcsException {
        if (interpolation != null) {
            ParameterValueGroup param = interpolateParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("Type").setValue((Object)interpolation);
            coverage = (GridCoverage2D)interpolateFactory.doOperation(param, hints);
        }
        return coverage;
    }

    public static GridCoverage2D scale(GridCoverage2D coverage, GridRange newGridRange, GridCoverage sourceCoverage, CoordinateReferenceSystem sourceCRS, GeneralEnvelope destinationEnvelopeInSourceCRS) {
        GridGeometry2D scaledGridGeometry = new GridGeometry2D((GridEnvelope)newGridRange, (Envelope)(destinationEnvelopeInSourceCRS != null ? destinationEnvelopeInSourceCRS : sourceCoverage.getEnvelope()));
        ParameterValueGroup param = resampleParams.clone();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("CoordinateReferenceSystem").setValue((Object)sourceCRS);
        param.parameter("GridGeometry").setValue((Object)scaledGridGeometry);
        param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
        GridCoverage2D scaledGridCoverage = (GridCoverage2D)resampleFactory.doOperation(param, hints);
        return scaledGridCoverage;
    }

    public static GridCoverage2D scale(GridCoverage2D coverage, GridGeometry2D scaledGridGeometry) {
        ParameterValueGroup param = resampleParams.clone();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("CoordinateReferenceSystem").setValue((Object)coverage.getCoordinateReferenceSystem());
        param.parameter("GridGeometry").setValue((Object)scaledGridGeometry);
        param.parameter("InterpolationType").setValue((Object)Interpolation.getInstance((int)0));
        GridCoverage2D scaledGridCoverage = (GridCoverage2D)resampleFactory.doOperation(param, hints);
        return scaledGridCoverage;
    }

    public static GridCoverage2D scale(double scaleX, double scaleY, float xTrans, float yTrans, Interpolation interpolation, BorderExtender be, GridCoverage2D gc) {
        ParameterValueGroup param = scaleParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("xScale").setValue((Object)new Float(scaleX));
        param.parameter("yScale").setValue((Object)new Float(scaleY));
        param.parameter("xTrans").setValue((Object)new Float(xTrans));
        param.parameter("yTrans").setValue((Object)new Float(yTrans));
        param.parameter("Interpolation").setValue((Object)interpolation);
        param.parameter("BorderExtender").setValue((Object)be);
        return (GridCoverage2D)scaleFactory.doOperation(param, hints);
    }

    public static GridCoverage2D resample(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation) {
        ParameterValueGroup param = resampleParams.clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)resampleFactory.doOperation(param, hints);
    }

    public static GridCoverage2D filteredSubsample(GridCoverage2D gc, int scaleXInt, int scaleYInt, Interpolation interpolation, BorderExtender be) {
        GridCoverage2D preScaledGridCoverage;
        if (scaleXInt == 1 && scaleYInt == 1) {
            preScaledGridCoverage = gc;
        } else {
            ParameterValueGroup param = filteredSubsampleParams.clone();
            param.parameter("source").setValue((Object)gc);
            param.parameter("scaleX").setValue((Object)new Integer(scaleXInt));
            param.parameter("scaleY").setValue((Object)new Integer(scaleYInt));
            if (interpolation.equals(new InterpolationNearest())) {
                param.parameter("qsFilterArray").setValue((Object)new float[]{1.0f});
            } else {
                param.parameter("qsFilterArray").setValue((Object)new float[]{0.5f, 0.33333334f, 0.0f, -0.083333336f});
            }
            param.parameter("Interpolation").setValue((Object)interpolation);
            param.parameter("BorderExtender").setValue((Object)be);
            preScaledGridCoverage = (GridCoverage2D)filteredSubsampleFactory.doOperation(param, hints);
        }
        return preScaledGridCoverage;
    }

    public static GridCoverage2D crop(Coverage coverage, GeneralEnvelope sourceEnvelope, CoordinateReferenceSystem sourceCRS, GeneralEnvelope destinationEnvelopeInSourceCRS, Boolean conserveEnvelope) throws WcsException {
        GridCoverage2D croppedGridCoverage;
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((Envelope)destinationEnvelopeInSourceCRS);
        intersectionEnvelope.setCoordinateReferenceSystem(sourceCRS);
        intersectionEnvelope.intersect((Envelope)sourceEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            throw new WcsException("The Intersection is null. Check the requested BBOX!");
        }
        if (!intersectionEnvelope.equals((Object)sourceEnvelope)) {
            ParameterValueGroup param = cropParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("Envelope").setValue((Object)intersectionEnvelope);
            param.parameter("ConserveEnvelope").setValue((Object)conserveEnvelope);
            croppedGridCoverage = (GridCoverage2D)cropFactory.doOperation(param, hints);
        } else {
            croppedGridCoverage = (GridCoverage2D)coverage;
        }
        croppedGridCoverage.prefetch(intersectionEnvelope.toRectangle2D());
        return croppedGridCoverage;
    }

    public static Coverage bandSelect(Map params, GridCoverage coverage) throws WcsException {
        int numDimensions = coverage.getNumSampleDimensions();
        HashMap<String, Integer> dims = new HashMap<String, Integer>();
        ArrayList selectedBands = new ArrayList();
        for (int d = 0; d < numDimensions; ++d) {
            dims.put("band" + (d + 1), new Integer(d));
        }
        if (params != null && !params.isEmpty()) {
            for (String param : params.keySet()) {
                if (!param.equalsIgnoreCase("BAND")) continue;
                try {
                    String values = (String)params.get(param);
                    if (values.indexOf("/") > 0) {
                        String[] minMaxRes = values.split("/");
                        int min = (int)Math.round(Double.parseDouble(minMaxRes[0]));
                        int max = (int)Math.round(Double.parseDouble(minMaxRes[1]));
                        double res = minMaxRes.length > 2 ? Double.parseDouble(minMaxRes[2]) : 0.0;
                        for (int v = min; v <= max; ++v) {
                            String key = param.toLowerCase() + v;
                            if (!dims.containsKey(key)) continue;
                            selectedBands.add(dims.get(key));
                        }
                        continue;
                    }
                    String[] bands = values.split(",");
                    for (int v = 0; v < bands.length; ++v) {
                        String key = param.toLowerCase() + bands[v];
                        if (!dims.containsKey(key)) continue;
                        selectedBands.add(dims.get(key));
                    }
                    if (selectedBands.size() != 0) continue;
                    throw new Exception("WRONG PARAM VALUES.");
                }
                catch (Exception e) {
                    throw new WcsException("Band parameters incorrectly specified: " + e.getLocalizedMessage());
                }
            }
        }
        int length = selectedBands.size();
        int[] bands = new int[length];
        for (int b = 0; b < length; ++b) {
            bands[b] = (Integer)selectedBands.get(b);
        }
        return WCSUtils.bandSelect(coverage, bands);
    }

    public static Coverage bandSelect(GridCoverage coverage, int[] bands) {
        GridCoverage bandSelectedCoverage;
        if (bands != null && bands.length > 0) {
            ParameterValueGroup param = bandSelectParams.clone();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("SampleDimensions").setValue((Object)bands);
            bandSelectedCoverage = bandSelectFactory.doOperation(param, hints);
        } else {
            bandSelectedCoverage = coverage;
        }
        return bandSelectedCoverage;
    }

    static {
        DefaultProcessor processor = new DefaultProcessor((RenderingHints)LENIENT_HINT);
        bandSelectParams = processor.getOperation("SelectSampleDimension").getParameters();
        cropParams = processor.getOperation("CoverageCrop").getParameters();
        interpolateParams = processor.getOperation("Interpolate").getParameters();
        scaleParams = processor.getOperation("Scale").getParameters();
        resampleParams = processor.getOperation("Resample").getParameters();
        filteredSubsampleParams = processor.getOperation("FilteredSubsample").getParameters();
        hints = new Hints(new HashMap(5));
        hints.add((RenderingHints)LENIENT_HINT);
    }
}

