/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestUtils {
    public static String schemaBaseURL(HttpServletRequest req) {
        return RequestUtils.baseURL(req) + "schemas/";
    }

    public static String baseURL(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(req.getScheme());
        sb.append("://").append(req.getServerName()).append(":").append(req.getServerPort()).append(req.getContextPath()).append("/");
        return sb.toString();
    }

    public static String proxifiedBaseURL(String baseUrl, String proxyBase) {
        if (proxyBase == null || proxyBase.trim().length() == 0) {
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            return baseUrl;
        }
        return proxyBase.endsWith("/") ? proxyBase : proxyBase + "/";
    }

    /*
     * WARNING - void declaration
     */
    public static String getVersionPreOws(List<String> providedList, List<String> acceptedList) {
        void var4_14;
        TreeSet<Version> provided = new TreeSet<Version>();
        for (String string : providedList) {
            provided.add(new Version(string));
        }
        if (acceptedList == null || acceptedList.isEmpty()) {
            return ((Version)provided.last()).toString();
        }
        TreeSet<Version> accepted = new TreeSet<Version>();
        for (String string : acceptedList) {
            RequestUtils.checkVersionNumber(string, null);
            accepted.add(new Version(string));
        }
        Iterator iterator = accepted.iterator();
        while (iterator.hasNext()) {
            Version version = (Version)iterator.next();
            if (provided.contains(version)) continue;
            iterator.remove();
        }
        Object var4_7 = null;
        if (!accepted.isEmpty()) {
            String string = ((Version)accepted.last()).toString();
        } else {
            void var4_12;
            for (String v4 : acceptedList) {
                accepted.add(new Version(v4));
            }
            if (((Version)accepted.last()).compareTo((Version)provided.first()) < 0) {
                String string = ((Version)provided.first()).toString();
            }
            if (((Version)accepted.first()).compareTo((Version)provided.last()) > 0) {
                String string = ((Version)provided.last()).toString();
            }
            if (var4_12 == null) {
                Version current;
                Iterator iterator2 = provided.iterator();
                Version last = (Version)iterator2.next();
                while (iterator2.hasNext() && (current = (Version)iterator2.next()).compareTo((Version)accepted.last()) <= 0) {
                    last = current;
                }
                String string = last.toString();
            }
        }
        return var4_14;
    }

    public static String getVersionOws11(List<String> providedList, List<String> acceptedList) {
        TreeSet<Version> provided = new TreeSet<Version>();
        for (String v : providedList) {
            provided.add(new Version(v));
        }
        if (acceptedList == null || acceptedList.isEmpty()) {
            return ((Version)provided.last()).toString();
        }
        ArrayList<Version> accepted = new ArrayList<Version>();
        for (String string : acceptedList) {
            RequestUtils.checkVersionNumber(string, "AcceptVersions");
            accepted.add(new Version(string));
        }
        Version negotiated = null;
        for (Version version : accepted) {
            if (!provided.contains(version)) continue;
            negotiated = version;
            break;
        }
        if (negotiated == null) {
            throw new ServiceException("Could not find any matching version", "VersionNegotiationFailed");
        }
        return negotiated.toString();
    }

    public static boolean isValidVersionNumber(String v) {
        return v.matches("[0-99]\\.[0-99]\\.[0-99]");
    }

    public static void checkVersionNumber(String v, String locator) throws ServiceException {
        if (!RequestUtils.isValidVersionNumber(v)) {
            String msg = v + " is an invalid version number";
            throw new ServiceException(msg, "VersionNegotiationFailed", locator);
        }
    }

    public static Version version(String v) {
        if (v == null || "".equals(v)) {
            return null;
        }
        if (!RequestUtils.isValidVersionNumber(v)) {
            String[] parts = v.split("\\.");
            switch (parts.length) {
                case 1: {
                    v = parts[0] + ".0.0";
                    break;
                }
                case 2: {
                    v = parts[0] + "." + parts[1] + ".0";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid version number: " + v + "");
                }
            }
        }
        return new Version(v);
    }

    public static Version matchHighestVersion(Version version, List versions) {
        if (version != null) {
            Version v;
            Version last = null;
            Iterator i = versions.iterator();
            while (i.hasNext() && version.compareTo(v = (Version)i.next()) >= 0) {
                last = v;
            }
            version = last == null ? (Version)versions.get(0) : last;
        } else {
            version = (Version)versions.get(versions.size() - 1);
        }
        return version;
    }
}

