/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.FactoryConfigurationError;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;

public class GetLegendGraphicKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)GetLegendGraphicKvpReader.class.getPackage().getName());
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();

    public GetLegendGraphicKvpReader(Map params, WMS wms) {
        super(params, wms);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        GetLegendGraphicRequest request = new GetLegendGraphicRequest(this.getWMS());
        request.setHttpServletRequest(httpRequest);
        String version = super.getRequestVersion();
        String layer = this.getValue("LAYER");
        String format = this.getValue("FORMAT");
        if (layer == null) {
            throw new ServiceException("LAYER parameter not present for GetLegendGraphic", "LayerNotDefined");
        }
        if (format == null) {
            throw new ServiceException("Missing FORMAT parameter for GetLegendGraphic", "MissingFormat");
        }
        MapLayerInfo mli = new MapLayerInfo();
        try {
            WMS wms = request.getWMS();
            Data catalog = wms.getData();
            FeatureTypeInfo fti = catalog.getFeatureTypeInfo(layer);
            mli.setFeature(fti);
            request.setLayer(mli.getFeature().getFeatureType());
        }
        catch (NoSuchElementException e) {
            try {
                CoverageInfo cvi = request.getWMS().getData().getCoverageInfo(layer);
                mli.setCoverage(cvi);
                FeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)cvi.getCoverage(null, null)));
                request.setLayer((SimpleFeatureType)feature.getSchema());
            }
            catch (NoSuchElementException ne) {
                throw new WmsException(ne, new StringBuffer(layer).append(" layer does not exists.").toString(), ne.getLocalizedMessage());
            }
            catch (TransformException te) {
                throw new WmsException(te, "Can't obtain the schema for the required layer.", te.getLocalizedMessage());
            }
            catch (FactoryConfigurationError fce) {
                throw new WmsException(fce, "Can't obtain the schema for the required layer.", fce.getLocalizedMessage());
            }
            catch (SchemaException se) {
                throw new WmsException(se, "Can't obtain the schema for the required layer.", se.getLocalizedMessage());
            }
            catch (IllegalAttributeException iae) {
                throw new WmsException(iae, "Can't obtain the schema for the required layer.", iae.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            throw new WmsException("Can't obtain the schema for the required layer.");
        }
        if (!GetLegendGraphicResponse.supportsFormat(format)) {
            throw new WmsException(new StringBuffer("Invalid graphic format: ").append(format).toString(), "InvalidFormat");
        }
        request.setFormat(format);
        this.parseOptionalParameters(request, mli);
        return request;
    }

    private void parseOptionalParameters(GetLegendGraphicRequest req, MapLayerInfo mli) {
        String exceptions;
        String height;
        String width;
        this.parseStyleAndRule(req, mli);
        String featureType = this.getValue("FEATURETYPE");
        String scale = this.getValue("SCALE");
        if (scale != null && !"".equals(scale)) {
            double scaleFactor = Double.valueOf(scale);
            req.setScale(scaleFactor);
        }
        if ((width = this.getValue("WIDTH")) != null && !"".equals(width)) {
            int legendW = Integer.valueOf(width);
            req.setWidth(legendW);
        }
        if ((height = this.getValue("HEIGHT")) != null && !"".equals(height)) {
            int legendH = Integer.valueOf(height);
            req.setHeight(legendH);
        }
        if ((exceptions = this.getValue("EXCEPTIONS")) != null) {
            req.setExceptionsFormat(exceptions);
        }
        String transparentParam = this.getValue("TRANSPARENT");
        boolean transparentBackground = "true".equalsIgnoreCase(transparentParam);
        req.setTransparent(transparentBackground);
        req.setLegendOptions(Requests.parseOptionParameter((String)this.getValue("LEGEND_OPTIONS")));
    }

    private void parseStyleAndRule(GetLegendGraphicRequest req, MapLayerInfo layer) {
        Style[] styles;
        String styleName = this.getValue("STYLE");
        String sldUrl = this.getValue("SLD");
        String sldBody = this.getValue("SLD_BODY");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("looking for style ").append(styleName).toString());
        }
        Style sldStyle = null;
        if (sldUrl != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD parameter");
            }
            styles = this.loadRemoteStyle(sldUrl);
            sldStyle = this.findStyle(styleName, styles);
        } else if (sldBody != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from SLD_BODY parameter");
            }
            styles = this.parseSldBody(sldBody);
            sldStyle = this.findStyle(styleName, styles);
        } else if (styleName != null && !"".equals(styleName)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("taking style from STYLE parameter");
            }
            sldStyle = req.getWMS().getData().getStyle(styleName);
        } else {
            sldStyle = layer.getDefaultStyle();
        }
        req.setStyle(sldStyle);
        String rule = this.getValue("RULE");
        Rule sldRule = this.extractRule(sldStyle, rule);
        if (sldRule != null) {
            req.setRule(sldRule);
        }
    }

    private Style findStyle(String styleName, Style[] styles) throws NoSuchElementException {
        if (styles == null || styles.length == 0) {
            throw new NoSuchElementException("No styles have been provided to search for " + styleName);
        }
        if (styleName == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("styleName is null, request in literal mode, returning first style");
            }
            return styles[0];
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request in library mode, looking for style ").append(styleName).toString());
        }
        StringBuffer noMatchNames = new StringBuffer();
        for (int i = 0; i < styles.length; ++i) {
            if (styles[i] != null && styleName.equals(styles[i].getName())) {
                return styles[i];
            }
            noMatchNames.append(styles[i].getName());
            if (i >= styles.length) continue;
            noMatchNames.append(", ");
        }
        throw new NoSuchElementException(styleName + " not found. Provided style names: " + noMatchNames);
    }

    private Style[] loadRemoteStyle(String sldUrl) throws WmsException {
        InputStream in;
        try {
            URL url = new URL(sldUrl);
            in = url.openStream();
        }
        catch (MalformedURLException e) {
            throw new WmsException(e, "Not a valid URL to an SLD document " + sldUrl, "loadRemoteStyle");
        }
        catch (IOException e) {
            throw new WmsException(e, "Can't open the SLD URL " + sldUrl, "loadRemoteStyle");
        }
        return this.parseSld(new InputStreamReader(in));
    }

    private Style[] parseSldBody(String sldBody) throws WmsException {
        return this.parseSld(new StringReader(sldBody));
    }

    private Style[] parseSld(Reader xmlIn) throws WmsException {
        SLDParser parser = new SLDParser(styleFactory, xmlIn);
        Style[] styles = null;
        try {
            styles = parser.readXML();
        }
        catch (RuntimeException e) {
            throw new WmsException(e);
        }
        if (styles == null || styles.length == 0) {
            throw new WmsException("Document contains no styles");
        }
        return styles;
    }

    private Rule extractRule(Style sldStyle, String rule) throws WmsException {
        Rule sldRule = null;
        if (rule != null && !"".equals(rule)) {
            FeatureTypeStyle[] fts = sldStyle.getFeatureTypeStyles();
            block0: for (int i = 0; i < fts.length; ++i) {
                Rule[] rules = fts[i].getRules();
                for (int r = 0; r < rules.length; ++r) {
                    if (!rule.equalsIgnoreCase(rules[r].getName())) continue;
                    sldRule = rules[r];
                    if (!LOGGER.isLoggable(Level.FINE)) continue block0;
                    LOGGER.fine(new StringBuffer("found requested rule: ").append(rule).toString());
                    continue block0;
                }
            }
            if (sldRule == null) {
                throw new WmsException("Style " + sldStyle.getName() + " does not contains a rule named " + rule);
            }
        }
        return sldRule;
    }
}

