/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests.readers;

import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.filter.FilterFilter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.opengis.filter.Filter;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.FilterHandlerImpl;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.ParserAdapter;

public abstract class WmsXmlRequestReader
extends XmlRequestReader {
    public WmsXmlRequestReader(WMS wms) {
        super((Service)wms);
    }

    public static Filter readFilter(Reader rawRequest) throws Exception {
        InputSource requestSource = new InputSource(rawRequest);
        FilterHandlerImpl contentHandler = new FilterHandlerImpl();
        FilterFilter filterParser = new FilterFilter((FilterHandler)contentHandler, null);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)filterParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ParserAdapter adapter = new ParserAdapter(parser.getParser());
        adapter.setContentHandler((ContentHandler)documentFilter);
        adapter.parse(requestSource);
        LOGGER.fine("just parsed: " + requestSource);
        LOGGER.fine("passing filter: " + contentHandler.getFilter());
        return contentHandler.getFilter();
    }
}

