/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.VerticalCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVerticalCS
extends AbstractCS
implements VerticalCS {
    private static final long serialVersionUID = 1201155778896630499L;
    public static DefaultVerticalCS ELLIPSOIDAL_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
    public static DefaultVerticalCS GRAVITY_RELATED_HEIGHT;
    @Deprecated
    public static DefaultVerticalCS GRAVITY_RELATED;
    public static DefaultVerticalCS DEPTH;

    public DefaultVerticalCS(VerticalCS cs) {
        super((CoordinateSystem)cs);
    }

    public DefaultVerticalCS(CoordinateSystemAxis axis) {
        super(DefaultVerticalCS.getProperties((IdentifiedObject)axis), new CoordinateSystemAxis[]{axis});
    }

    public DefaultVerticalCS(String name, CoordinateSystemAxis axis) {
        super(name, new CoordinateSystemAxis[]{axis});
    }

    public DefaultVerticalCS(Map<String, ?> properties, CoordinateSystemAxis axis) {
        super(properties, new CoordinateSystemAxis[]{axis});
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection direction) {
        return AxisDirection.UP.equals((Object)direction.absolute());
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", coord1);
        this.ensureDimensionMatch("coord2", coord2);
        return new Measure(Math.abs(coord1[0] - coord2[0]), this.getDistanceUnit());
    }

    static {
        GRAVITY_RELATED = GRAVITY_RELATED_HEIGHT = new DefaultVerticalCS(DefaultCoordinateSystemAxis.GRAVITY_RELATED_HEIGHT);
        DEPTH = new DefaultVerticalCS(DefaultCoordinateSystemAxis.DEPTH);
    }
}

