/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.event.impl.CatalogAddEventImpl;
import org.geoserver.catalog.event.impl.CatalogModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogRemoveEventImpl;
import org.geoserver.catalog.impl.CatalogFactoryImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogImpl
implements Catalog {
    protected MultiHashMap stores = new MultiHashMap();
    protected MultiHashMap resources = new MultiHashMap();
    protected HashMap<String, NamespaceInfo> namespaces = new HashMap();
    protected HashMap<String, WorkspaceInfo> workspaces = new HashMap();
    protected List<LayerInfo> layers = new ArrayList<LayerInfo>();
    protected List<MapInfo> maps = new ArrayList<MapInfo>();
    protected List<LayerGroupInfo> layerGroups = new ArrayList<LayerGroupInfo>();
    protected List<StyleInfo> styles = new ArrayList<StyleInfo>();
    protected List listeners = new ArrayList();
    protected ResourcePool resourcePool = new ResourcePool();
    protected GeoServerResourceLoader resourceLoader;

    @Override
    public CatalogFactory getFactory() {
        return new CatalogFactoryImpl(this);
    }

    @Override
    public void add(StoreInfo store) {
        if (store.getWorkspace() == null) {
            store.setWorkspace(this.getDefaultWorkspace());
        }
        this.validate(store);
        this.resolve(store);
        this.stores.put(store.getClass(), (Object)store);
        this.added(store);
    }

    void validate(StoreInfo store) {
        if (store.getName() == null) {
            throw new IllegalArgumentException("Store name must not be null");
        }
        if (store.getWorkspace() == null) {
            throw new IllegalArgumentException("Store must be part of a workspace");
        }
    }

    @Override
    public void remove(StoreInfo store) {
        store = CatalogImpl.unwrap(store);
        this.stores.remove(store.getClass(), (Object)store);
        this.removed(store);
    }

    @Override
    public void save(StoreInfo store) {
        this.validate(store);
        if (store.getId() == null) {
            this.add(store);
            return;
        }
        this.saved(store);
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        List l = this.lookup(clazz, this.stores);
        for (StoreInfo store : l) {
            if (!id.equals(store.getId())) continue;
            return (T)ModificationProxy.create(store, clazz);
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String name, Class<T> clazz) {
        Object store2 = this.getStoreByName((WorkspaceInfo)null, name, clazz);
        if (store2 != null) {
            return store2;
        }
        List l = this.lookup(clazz, this.stores);
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Object store2 : l) {
            if (!name.equals(store2.getName())) continue;
            matches.add(store2);
        }
        if (matches.size() == 1) {
            return (T)ModificationProxy.create((StoreInfo)matches.get(0), clazz);
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        List l = this.lookup(clazz, this.stores);
        for (StoreInfo store : l) {
            if (!name.equals(store.getName()) || !store.getWorkspace().equals(workspace)) continue;
            return (T)ModificationProxy.create(store, clazz);
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String workspaceName, String name, Class<T> clazz) {
        return this.getStoreByName(workspaceName != null ? this.getWorkspace(workspaceName) : null, name, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(String workspaceName, Class<T> clazz) {
        WorkspaceInfo workspace = null;
        if (workspaceName != null && (workspace = this.getWorkspaceByName(workspaceName)) == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getStoresByWorkspace(workspace, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        if (workspace == null) {
            workspace = this.getDefaultWorkspace();
        }
        List all = this.lookup(clazz, this.stores);
        ArrayList<StoreInfo> matches = new ArrayList<StoreInfo>();
        for (StoreInfo store : all) {
            if (!workspace.equals(store.getWorkspace())) continue;
            matches.add(store);
        }
        return ModificationProxy.createList(matches, clazz);
    }

    public List getStores(Class clazz) {
        return ModificationProxy.createList(this.lookup(clazz, this.stores), clazz);
    }

    @Override
    public DataStoreInfo getDataStore(String id) {
        return this.getStore(id, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String name) {
        return this.getStoreByName(name, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String workspaceName, String name) {
        return this.getStoreByName(workspaceName, name, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(WorkspaceInfo workspace, String name) {
        return this.getStoreByName(workspace, name, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(String workspaceName) {
        return this.getStoresByWorkspace(workspaceName, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo workspace) {
        return this.getStoresByWorkspace(workspace, DataStoreInfo.class);
    }

    public List getDataStores() {
        return this.getStores(DataStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStore(String id) {
        return this.getStore(id, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String name) {
        return this.getStoreByName(name, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String workspaceName, String name) {
        return this.getStoreByName(workspaceName, name, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo workspace, String name) {
        return this.getStoreByName(workspace, name, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String workspaceName) {
        return this.getStoresByWorkspace(workspaceName, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo workspace) {
        return this.getStoresByWorkspace(workspace, CoverageStoreInfo.class);
    }

    public List getCoverageStores() {
        return this.getStores(CoverageStoreInfo.class);
    }

    @Override
    public void add(ResourceInfo resource) {
        if (resource.getNamespace() == null) {
            resource.setNamespace(this.getDefaultNamespace());
        }
        this.validate(resource);
        this.resolve(resource);
        this.resources.put(resource.getClass(), (Object)resource);
        this.added(resource);
    }

    void validate(ResourceInfo resource) {
        if (resource.getStore() == null) {
            throw new IllegalArgumentException("Resource must be part of a store");
        }
        if (resource.getNamespace() == null) {
            throw new IllegalArgumentException("Resource must be part of a namespace");
        }
    }

    @Override
    public void remove(ResourceInfo resource) {
        resource = CatalogImpl.unwrap(resource);
        this.resources.remove(resource.getClass(), (Object)resource);
        this.removed(resource);
    }

    @Override
    public void save(ResourceInfo resource) {
        this.validate(resource);
        this.saved(resource);
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        List l = this.lookup(clazz, this.resources);
        for (ResourceInfo resource : l) {
            if (!id.equals(resource.getId())) continue;
            return (T)ModificationProxy.create(resource, clazz);
        }
        return null;
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String ns, String name, Class<T> clazz) {
        if (ns == null && this.getDefaultNamespace() != null) {
            ns = this.getDefaultNamespace().getPrefix();
        }
        List l = this.lookup(clazz, this.resources);
        for (ResourceInfo resource : l) {
            NamespaceInfo namespace;
            if (!name.equals(resource.getName()) || !((namespace = resource.getNamespace()) != null ? namespace.getPrefix().equals(ns) || namespace.getURI().equals(ns) : ns == null)) continue;
            return (T)ModificationProxy.create(resource, clazz);
        }
        return null;
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo ns, String name, Class<T> clazz) {
        return this.getResourceByName(ns != null ? ns.getPrefix() : null, name, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String name, Class<T> clazz) {
        Object resource2 = this.getResourceByName((String)null, name, clazz);
        if (resource2 != null) {
            return resource2;
        }
        ArrayList<Object> matches = new ArrayList<Object>();
        List l = this.lookup(clazz, this.resources);
        for (Object resource2 : l) {
            if (!name.equals(resource2.getName())) continue;
            matches.add(resource2);
        }
        if (matches.size() == 1) {
            return (T)ModificationProxy.create((ResourceInfo)matches.get(0), clazz);
        }
        return null;
    }

    public List getResources(Class clazz) {
        return ModificationProxy.createList(this.lookup(clazz, this.resources), clazz);
    }

    public List getResourcesByNamespace(NamespaceInfo namespace, Class clazz) {
        List all = this.lookup(clazz, this.resources);
        ArrayList<ResourceInfo> matches = new ArrayList<ResourceInfo>();
        if (namespace == null) {
            namespace = this.getDefaultNamespace();
        }
        for (ResourceInfo resource : all) {
            if (namespace != null) {
                if (!((Object)namespace).equals(resource.getNamespace())) continue;
                matches.add(resource);
                continue;
            }
            if (resource.getNamespace() != null) continue;
            matches.add(resource);
        }
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String namespace, Class<T> clazz) {
        if (namespace == null) {
            return this.getResourcesByNamespace((NamespaceInfo)null, (Class)clazz);
        }
        NamespaceInfo ns = this.getNamespace(namespace);
        if (ns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getResourcesByNamespace(ns, (Class)clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        List all = this.lookup(clazz, this.resources);
        for (ResourceInfo resource : all) {
            if (!name.equals(resource.getName()) || !store.equals(resource.getStore())) continue;
            return (T)ModificationProxy.create(resource, clazz);
        }
        return null;
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        List all = this.lookup(clazz, this.resources);
        ArrayList<ResourceInfo> matches = new ArrayList<ResourceInfo>();
        for (ResourceInfo resource : all) {
            if (!store.equals(resource.getStore())) continue;
            matches.add(resource);
        }
        return ModificationProxy.createList(matches, clazz);
    }

    @Override
    public FeatureTypeInfo getFeatureType(String id) {
        return this.getResource(id, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String ns, String name) {
        return this.getResourceByName(ns, name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo ns, String name) {
        return this.getResourceByName(ns, name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String name) {
        return this.getResourceByName(name, FeatureTypeInfo.class);
    }

    public List getFeatureTypes() {
        return this.getResources(FeatureTypeInfo.class);
    }

    public List getFeatureTypesByNamespace(NamespaceInfo namespace) {
        return this.getResourcesByNamespace(namespace, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo dataStore, String name) {
        return this.getResourceByStore(dataStore, name, FeatureTypeInfo.class);
    }

    public List getFeatureTypesByDataStore(DataStoreInfo store) {
        return this.getResourcesByStore(store, FeatureTypeInfo.class);
    }

    @Override
    public CoverageInfo getCoverage(String id) {
        return this.getResource(id, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(String ns, String name) {
        return this.getResourceByName(ns, name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(NamespaceInfo ns, String name) {
        return this.getResourceByName(ns, name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(String name) {
        return this.getResourceByName(name, CoverageInfo.class);
    }

    public List getCoverages() {
        return this.getResources(CoverageInfo.class);
    }

    public List getCoveragesByNamespace(NamespaceInfo namespace) {
        return this.getResourcesByNamespace(namespace, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo coverageStore, String name) {
        return this.getResourceByStore(coverageStore, name, CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo store) {
        return this.getResourcesByStore(store, CoverageInfo.class);
    }

    @Override
    public void add(LayerInfo layer) {
        this.validate(layer);
        this.resolve(layer);
        if (layer.getType() == null) {
            if (layer.getResource() instanceof FeatureTypeInfo) {
                layer.setType(LayerInfo.Type.VECTOR);
            } else if (layer.getResource() instanceof CoverageInfo) {
                layer.setType(LayerInfo.Type.RASTER);
            } else {
                String msg = "Layer type not set and can't be derived from resource";
                throw new IllegalArgumentException(msg);
            }
        }
        this.layers.add(layer);
        this.added(layer);
    }

    void validate(LayerInfo layer) {
        if (layer.getName() == null) {
            throw new NullPointerException("Layer name must not be null");
        }
        if (layer.getResource() == null) {
            throw new NullPointerException("Layer resource must not be null");
        }
    }

    @Override
    public void remove(LayerInfo layer) {
        this.layers.remove(CatalogImpl.unwrap(layer));
        this.removed(layer);
    }

    @Override
    public void save(LayerInfo layer) {
        this.validate(layer);
        this.saved(layer);
    }

    @Override
    public LayerInfo getLayer(String id) {
        for (LayerInfo layer : this.layers) {
            if (!id.equals(layer.getId())) continue;
            return ModificationProxy.create(layer, LayerInfo.class);
        }
        return null;
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        String prefix = null;
        String resource = null;
        int colon = name.indexOf(58);
        if (colon != -1) {
            prefix = name.substring(0, colon);
            resource = name.substring(colon + 1);
            for (LayerInfo layer : this.layers) {
                ResourceInfo r = layer.getResource();
                if (!prefix.equals(r.getNamespace().getPrefix()) || !resource.equals(r.getName())) continue;
                return ModificationProxy.create(layer, LayerInfo.class);
            }
        } else {
            for (LayerInfo layer : this.layers) {
                if (!name.equals(layer.getName())) continue;
                return ModificationProxy.create(layer, LayerInfo.class);
            }
        }
        return null;
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        ArrayList<LayerInfo> matches = new ArrayList<LayerInfo>();
        for (LayerInfo layer : this.layers) {
            if (!resource.equals(layer.getResource())) continue;
            matches.add(layer);
        }
        return ModificationProxy.createList(matches, LayerInfo.class);
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        ArrayList<LayerInfo> matches = new ArrayList<LayerInfo>();
        for (LayerInfo layer : this.layers) {
            if (!style.equals(layer.getDefaultStyle()) && !layer.getStyles().contains(style)) continue;
            matches.add(layer);
        }
        return ModificationProxy.createList(matches, LayerInfo.class);
    }

    public List getLayers() {
        return ModificationProxy.createList(new ArrayList<LayerInfo>(this.layers), LayerInfo.class);
    }

    @Override
    public MapInfo getMap(String id) {
        for (MapInfo map : this.maps) {
            if (!id.equals(map.getId())) continue;
            return ModificationProxy.create(map, MapInfo.class);
        }
        return null;
    }

    @Override
    public MapInfo getMapByName(String name) {
        for (MapInfo map : this.maps) {
            if (!name.equals(map.getName())) continue;
            return ModificationProxy.create(map, MapInfo.class);
        }
        return null;
    }

    @Override
    public List<MapInfo> getMaps() {
        return ModificationProxy.createList(new ArrayList<MapInfo>(this.maps), MapInfo.class);
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        this.validate(layerGroup);
        this.resolve(layerGroup);
        if (layerGroup.getStyles().isEmpty()) {
            for (LayerInfo l : layerGroup.getLayers()) {
                layerGroup.getStyles().add(l.getDefaultStyle());
            }
        }
        this.layerGroups.add(layerGroup);
        this.added(layerGroup);
    }

    void validate(LayerGroupInfo layerGroup) {
        if (layerGroup.getName() == null) {
            throw new NullPointerException("Layer group name must not be null");
        }
        if (layerGroup.getLayers() == null || layerGroup.getLayers().isEmpty()) {
            throw new NullPointerException("Layer group must not be empty");
        }
        if (layerGroup.getStyles() != null && !layerGroup.getStyles().isEmpty() && layerGroup.getStyles().size() != layerGroup.getLayers().size()) {
            throw new IllegalArgumentException("Layer group has different number of styles than layers");
        }
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        this.layerGroups.remove(CatalogImpl.unwrap(layerGroup));
        this.removed(layerGroup);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        this.saved(layerGroup);
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return ModificationProxy.createList(new ArrayList<LayerGroupInfo>(this.layerGroups), LayerGroupInfo.class);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        for (LayerGroupInfo layerGroup : this.layerGroups) {
            if (!id.equals(layerGroup.getId())) continue;
            return ModificationProxy.create(layerGroup, LayerGroupInfo.class);
        }
        return null;
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        for (LayerGroupInfo layerGroup : this.layerGroups) {
            if (!name.equals(layerGroup.getName())) continue;
            return ModificationProxy.create(layerGroup, LayerGroupInfo.class);
        }
        return null;
    }

    @Override
    public void add(MapInfo map) {
        this.resolve(map);
        this.maps.add(map);
        this.added(map);
    }

    @Override
    public void remove(MapInfo map) {
        this.maps.remove(CatalogImpl.unwrap(map));
        this.removed(map);
    }

    @Override
    public void save(MapInfo map) {
        this.saved(map);
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        for (NamespaceInfo namespace : this.namespaces.values()) {
            if (!id.equals(namespace.getId())) continue;
            return ModificationProxy.create(namespace, NamespaceInfo.class);
        }
        return null;
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        NamespaceInfo ns = this.namespaces.get(prefix);
        return ns != null ? ModificationProxy.create(ns, NamespaceInfo.class) : null;
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        for (NamespaceInfo namespace : this.namespaces.values()) {
            if (!uri.equals(namespace.getURI())) continue;
            return ModificationProxy.create(namespace, NamespaceInfo.class);
        }
        return null;
    }

    public List getNamespaces() {
        ArrayList<NamespaceInfo> ns = new ArrayList<NamespaceInfo>();
        for (Map.Entry<String, NamespaceInfo> e : this.namespaces.entrySet()) {
            if (e.getKey() == null) continue;
            ns.add(e.getValue());
        }
        return ModificationProxy.createList(ns, NamespaceInfo.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(NamespaceInfo namespace) {
        this.validate(namespace);
        this.resolve(namespace);
        HashMap<String, NamespaceInfo> hashMap = this.namespaces;
        synchronized (hashMap) {
            this.namespaces.put(namespace.getPrefix(), namespace);
            if (this.namespaces.get(null) == null) {
                this.namespaces.put(null, namespace);
            }
        }
        this.added(namespace);
    }

    void validate(NamespaceInfo namespace) {
        if (namespace.getPrefix() == null) {
            throw new NullPointerException("Namespace prefix must not be null");
        }
        if (namespace.getURI() == null) {
            throw new NullPointerException("Namespace uri must not be null");
        }
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        this.namespaces.remove(namespace.getPrefix());
        this.removed(namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(NamespaceInfo namespace) {
        this.validate(namespace);
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(namespace);
        NamespaceInfo ns = (NamespaceInfo)h.getProxyObject();
        if (!namespace.getPrefix().equals(ns.getPrefix())) {
            HashMap<String, NamespaceInfo> hashMap = this.namespaces;
            synchronized (hashMap) {
                this.namespaces.remove(ns.getPrefix());
                this.namespaces.put(namespace.getPrefix(), ns);
            }
        }
        this.saved(namespace);
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return this.namespaces.containsKey(null) ? ModificationProxy.create(this.namespaces.get(null), NamespaceInfo.class) : null;
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        NamespaceInfo ns = this.namespaces.get(defaultNamespace.getPrefix());
        if (ns == null) {
            throw new IllegalArgumentException("No such namespace: '" + defaultNamespace.getPrefix() + "'");
        }
        this.namespaces.put(null, ns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(WorkspaceInfo workspace) {
        this.validate(workspace);
        if (this.workspaces.containsKey(workspace.getName())) {
            throw new IllegalArgumentException("Workspace with name '" + workspace.getName() + "' already exists.");
        }
        this.resolve(workspace);
        HashMap<String, WorkspaceInfo> hashMap = this.workspaces;
        synchronized (hashMap) {
            this.workspaces.put(workspace.getName(), workspace);
            if (this.workspaces.get(null) == null) {
                this.workspaces.put(null, workspace);
            }
        }
        this.added(workspace);
    }

    void validate(WorkspaceInfo workspace) {
        if (workspace.getName() == null) {
            throw new NullPointerException("workspace name must not be null");
        }
    }

    @Override
    public void remove(WorkspaceInfo workspace) {
        if (this.getNamespaceByPrefix(workspace.getName()) != null) {
            throw new IllegalStateException("Cannot delete workspace with linked namespace");
        }
        this.workspaces.remove(workspace.getName());
        this.removed(workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WorkspaceInfo workspace) {
        this.validate(workspace);
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(workspace);
        WorkspaceInfo ws = (WorkspaceInfo)h.getProxyObject();
        if (!workspace.getName().equals(ws.getName())) {
            HashMap<String, WorkspaceInfo> hashMap = this.workspaces;
            synchronized (hashMap) {
                this.workspaces.remove(ws.getName());
                this.workspaces.put(workspace.getName(), ws);
            }
        }
        this.saved(workspace);
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return this.workspaces.containsKey(null) ? ModificationProxy.create(this.workspaces.get(null), WorkspaceInfo.class) : null;
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        this.workspaces.put(null, workspace);
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        ArrayList<WorkspaceInfo> ws = new ArrayList<WorkspaceInfo>();
        for (Map.Entry<String, WorkspaceInfo> e : this.workspaces.entrySet()) {
            if (e.getKey() == null) continue;
            ws.add(e.getValue());
        }
        return ModificationProxy.createList(ws, WorkspaceInfo.class);
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        for (WorkspaceInfo ws : this.workspaces.values()) {
            if (!id.equals(ws.getId())) continue;
            return ModificationProxy.create(ws, WorkspaceInfo.class);
        }
        return null;
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        return this.workspaces.containsKey(name) ? ModificationProxy.create(this.workspaces.get(name), WorkspaceInfo.class) : null;
    }

    @Override
    public StyleInfo getStyle(String id) {
        for (StyleInfo style : this.styles) {
            if (!id.equals(style.getId())) continue;
            return ModificationProxy.create(style, StyleInfo.class);
        }
        return null;
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        for (StyleInfo style : this.styles) {
            if (!name.equals(style.getName())) continue;
            return ModificationProxy.create(style, StyleInfo.class);
        }
        return null;
    }

    public List getStyles() {
        return ModificationProxy.createList(this.styles, StyleInfo.class);
    }

    @Override
    public void add(StyleInfo style) {
        this.validate(style);
        this.resolve(style);
        this.styles.add(style);
        this.added(style);
    }

    void validate(StyleInfo style) {
        if (style.getName() == null) {
            throw new NullPointerException("Style name must not be null");
        }
        if (style.getFilename() == null) {
            throw new NullPointerException("Style fileName must not be null");
        }
    }

    @Override
    public void remove(StyleInfo style) {
        this.styles.remove(CatalogImpl.unwrap(style));
        this.removed(style);
    }

    @Override
    public void save(StyleInfo style) {
        this.validate(style);
        this.saved(style);
    }

    public Collection getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    @Override
    public void addListener(CatalogListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(CatalogListener listener) {
        this.listeners.remove(listener);
    }

    public Iterator search(String cql) {
        return null;
    }

    @Override
    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    @Override
    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    @Override
    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public GeoServerResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public void dispose() {
        if (this.stores != null) {
            this.stores.clear();
        }
        if (this.resources != null) {
            this.resources.clear();
        }
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (this.workspaces != null) {
            this.workspaces.clear();
        }
        if (this.layers != null) {
            this.layers.clear();
        }
        if (this.layerGroups != null) {
            this.layerGroups.clear();
        }
        if (this.maps != null) {
            this.maps.clear();
        }
        if (this.styles != null) {
            this.styles.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.resourcePool != null) {
            this.resourcePool.dispose();
        }
    }

    List lookup(Class clazz, MultiHashMap map) {
        ArrayList result = new ArrayList();
        for (Class key : map.keySet()) {
            if (!clazz.isAssignableFrom(key)) continue;
            result.addAll(map.getCollection((Object)key));
        }
        return result;
    }

    protected void added(Object object) {
        this.fireAdded(object);
    }

    protected void fireAdded(Object object) {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource(object);
        this.event(event);
    }

    protected void saved(Object object) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(object);
        Object real = h.getProxyObject();
        List<String> propertyNames = h.getPropertyNames();
        List<Object> newValues = h.getNewValues();
        List<Object> oldValues = h.getOldValues();
        this.fireModified(real, propertyNames, oldValues, newValues);
        h.commit();
        this.syncIdWithName(real);
    }

    protected void fireModified(Object object, List propertyNames, List oldValues, List newValues) {
        CatalogModifyEventImpl event = new CatalogModifyEventImpl();
        event.setSource(object);
        event.setPropertyNames(propertyNames);
        event.setOldValues(oldValues);
        event.setNewValues(newValues);
        this.event(event);
    }

    protected void removed(Object object) {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource(object);
        this.event(event);
    }

    protected void event(CatalogEvent event) {
        for (CatalogListener listener : this.listeners) {
            if (event instanceof CatalogAddEvent) {
                listener.handleAddEvent((CatalogAddEvent)event);
                continue;
            }
            if (event instanceof CatalogRemoveEvent) {
                listener.handleRemoveEvent((CatalogRemoveEvent)event);
                continue;
            }
            if (!(event instanceof CatalogModifyEvent)) continue;
            listener.handleModifyEvent((CatalogModifyEvent)event);
        }
    }

    public void resolve() {
        if (this.workspaces == null) {
            this.workspaces = new HashMap();
        }
        for (WorkspaceInfo ws : this.workspaces.values()) {
            this.resolve(ws);
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        for (NamespaceInfo ns : this.namespaces.values()) {
            this.resolve(ns);
        }
        if (this.stores == null) {
            this.stores = new MultiHashMap();
        }
        for (Object o : this.stores.values()) {
            this.resolve((StoreInfoImpl)o);
        }
        if (this.styles == null) {
            this.styles = new ArrayList<StyleInfo>();
        }
        for (StyleInfo s : this.styles) {
            this.resolve(s);
        }
        if (this.resources == null) {
            this.resources = new MultiHashMap();
        }
        for (Object o : this.resources.values()) {
            this.resolve((ResourceInfo)o);
        }
        if (this.layers == null) {
            this.layers = new ArrayList<LayerInfo>();
        }
        for (LayerInfo l : this.layers) {
            this.resolve(l);
        }
        if (this.layerGroups == null) {
            this.layerGroups = new ArrayList<LayerGroupInfo>();
        }
        for (LayerGroupInfo lg : this.layerGroups) {
            this.resolve(lg);
        }
        if (this.maps == null) {
            this.maps = new ArrayList<MapInfo>();
        }
        for (MapInfo m : this.maps) {
            this.resolve(m);
        }
        if (this.resourcePool == null) {
            this.resourcePool = new ResourcePool();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    protected void resolve(WorkspaceInfo workspace) {
        this.syncIdWithName(workspace);
    }

    protected void resolve(NamespaceInfo namespace) {
        Object prefix = OwsUtils.get((Object)namespace, (String)"prefix");
        OwsUtils.set((Object)namespace, (String)"id", (Object)prefix);
    }

    protected void resolve(StoreInfo store) {
        this.syncIdWithName(store);
        StoreInfoImpl s = (StoreInfoImpl)store;
        WorkspaceInfo resolved = ResolvingProxy.resolve(this, s.getWorkspace());
        if (resolved != null) {
            s.setWorkspace(resolved);
        }
        if (s.getMetadata() == null) {
            s.setMetadata(new HashMap());
        }
        s.setCatalog(this);
    }

    protected void resolve(ResourceInfo resource) {
        this.syncIdWithName(resource);
        ResourceInfoImpl r = (ResourceInfoImpl)resource;
        StoreInfo resolved = ResolvingProxy.resolve(this, r.getStore());
        if (resolved != null) {
            r.setStore(resolved);
        }
        if (r.getMetadata() == null) {
            r.setMetadata(new HashMap());
        }
        r.setCatalog(this);
        if (resource instanceof FeatureTypeInfo) {
            this.resolve((FeatureTypeInfo)resource);
        }
    }

    protected void resolve(FeatureTypeInfo featureType) {
        FeatureTypeInfoImpl ft = (FeatureTypeInfoImpl)featureType;
        if (ft.getAttributes() == null) {
            ft.setAttributes(new ArrayList<AttributeTypeInfo>());
        }
    }

    protected void resolve(LayerInfo layer) {
        this.syncIdWithName(layer);
    }

    protected void resolve(LayerGroupInfo layerGroup) {
        Object resolved;
        int i;
        this.syncIdWithName(layerGroup);
        LayerGroupInfoImpl lg = (LayerGroupInfoImpl)layerGroup;
        for (i = 0; i < lg.getLayers().size(); ++i) {
            LayerInfo l = lg.getLayers().get(i);
            resolved = ResolvingProxy.resolve(this, l);
            lg.getLayers().set(i, (LayerInfo)resolved);
        }
        if (lg.getStyles() == null) {
            lg.setStyles(new ArrayList<StyleInfo>());
        }
        for (i = 0; i < lg.getStyles().size(); ++i) {
            StyleInfo s = lg.getStyles().get(i);
            resolved = ResolvingProxy.resolve(this, s);
            lg.getStyles().set(i, (StyleInfo)resolved);
        }
        if (lg.getMetadata() == null) {
            lg.setMetadata(new HashMap<String, Serializable>());
        }
    }

    protected void resolve(StyleInfo style) {
        this.syncIdWithName(style);
        ((StyleInfoImpl)style).setCatalog(this);
    }

    protected void resolve(MapInfo map) {
        this.syncIdWithName(map);
    }

    protected void syncIdWithName(Object o) {
        if (OwsUtils.getter(o.getClass(), (String)"name", String.class) != null && OwsUtils.getter(o.getClass(), (String)"id", String.class) != null) {
            Object name = OwsUtils.get((Object)o, (String)"name");
            OwsUtils.set((Object)o, (String)"id", (Object)name);
        }
    }

    public void sync(CatalogImpl other) {
        this.stores = other.stores;
        this.resources = other.resources;
        this.namespaces = other.namespaces;
        this.workspaces = other.workspaces;
        this.layers = other.layers;
        this.maps = other.maps;
        this.layerGroups = other.layerGroups;
        this.styles = other.styles;
        this.listeners = other.listeners;
        if (this.resourcePool != other.resourcePool) {
            this.resourcePool.dispose();
            this.resourcePool = other.resourcePool;
        }
    }

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }
}

