/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.geoserver.config.util.LegacyServicesReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyImporterSupport {
    protected LegacyServicesReader reader(File dir) throws Exception {
        File servicesFile = new File(dir, "services.xml");
        if (!servicesFile.exists()) {
            throw new FileNotFoundException("Could not find services.xml under:" + dir.getAbsolutePath());
        }
        LegacyServicesReader reader = new LegacyServicesReader();
        reader.read(servicesFile);
        return reader;
    }

    protected Object value(Object value, Object def) {
        return value != null ? value : def;
    }

    protected <T> T get(Map map, String key, Class<T> clazz, T def) {
        Object o = map.get(key);
        if (o == null) {
            if (def != null) {
                return def;
            }
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    return (T)Integer.valueOf(0);
                }
                if (clazz == Double.TYPE) {
                    return (T)Double.valueOf(0.0);
                }
                if (clazz == Boolean.TYPE) {
                    return (T)Boolean.FALSE;
                }
            }
            return null;
        }
        return (T)o;
    }

    protected <T> T get(Map map, String key, Class<T> clazz) {
        return this.get(map, key, clazz, null);
    }
}

