/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.adapters;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;
import org.vfny.geoserver.global.Service;

public class KvpRequestReaderAdapter
extends KvpRequestReader
implements HttpServletRequestAware {
    Class delegateClass;
    Service service;
    HttpServletRequest request;

    public KvpRequestReaderAdapter(Class requestBean, Class delegateClass, Service service) {
        super(requestBean);
        this.delegateClass = delegateClass;
        this.service = service;
    }

    public void setHttpRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Object createRequest() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        Enumeration pnames = this.request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = this.request.getParameter(paramName);
            kvp.put(paramName.toUpperCase(), paramValue);
        }
        Constructor constructor = null;
        for (Class<?> clazz = this.service.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                constructor = this.delegateClass.getConstructor(Map.class, clazz);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (constructor == null) {
            throw new IllegalStateException("No appropriate constructor");
        }
        org.vfny.geoserver.util.requests.readers.KvpRequestReader delegate = (org.vfny.geoserver.util.requests.readers.KvpRequestReader)constructor.newInstance(kvp, this.service);
        return delegate.getRequest(this.request);
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        return request;
    }
}

