/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.io.File;
import org.vfny.geoserver.global.dto.DataTransferObject;

public final class StyleDTO
implements DataTransferObject {
    private String id;
    private File filename;
    private boolean _default;

    public StyleDTO() {
    }

    public StyleDTO(StyleDTO style) {
        if (style == null) {
            throw new NullPointerException();
        }
        this.id = style.getId();
        this.filename = new File(style.getFilename().toString());
        this._default = style.isDefault();
    }

    public Object clone() {
        return new StyleDTO(this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StyleDTO)) {
            return false;
        }
        StyleDTO style = (StyleDTO)obj;
        boolean r = true;
        boolean bl = r = r && this.id == style.getId();
        if (this.filename != null) {
            r = r && this.filename.equals(style.getFilename());
        }
        r = r && this._default == style.isDefault();
        return r;
    }

    public int hashCode() {
        int r = 1;
        if (this.id != null) {
            r *= this.id.hashCode();
        }
        if (this.filename != null) {
            r *= this.filename.hashCode();
        }
        return r;
    }

    public boolean isDefault() {
        return this._default;
    }

    public File getFilename() {
        return this.filename;
    }

    public String getId() {
        return this.id;
    }

    public void setDefault(boolean b) {
        this._default = b;
    }

    public void setFilename(File file) {
        this.filename = file;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String toString() {
        return "Style: " + this.id + " at " + this.filename + (this._default ? "default" : "");
    }
}

