/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.rest.seed.SeedRestlet;
import org.geowebcache.rest.seed.SeederThreadPoolExecutor;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.wms.BBOX;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedFormRestlet
extends GWCRestlet {
    SeederThreadPoolExecutor threadPool;
    TileLayerDispatcher layerDispatcher;
    StorageBroker storageBroker;
    SeedRestlet seedRestlet;

    public void handle(Request request, Response response) {
        block4: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block4;
                }
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                    break block4;
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
        }
    }

    public void doGet(Request request, Response response) throws RestletException {
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)request.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        TileLayer tl = SeedFormRestlet.findTileLayer(layerName, this.layerDispatcher);
        tl.isInitialized();
        response.setEntity(this.makeFormPage(tl), MediaType.TEXT_HTML);
    }

    public void doPost(Request req, Response resp) throws RestletException {
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        Form form = req.getEntityAsForm();
        if (form == null) {
            throw new RestletException("Unable to parse form result.", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        TileLayer tl = SeedFormRestlet.findTileLayer(layerName, this.layerDispatcher);
        if (form != null && form.getFirst("kill_thread") != null) {
            this.handleKillThreadPost(form, tl, resp);
        } else if (form != null && form.getFirst("minX") != null) {
            this.handleDoSeedPost(form, tl, resp);
        } else {
            throw new RestletException("Unknown or malformed request. Please try again, somtimes the form is not properly received. This frequently happens on the first POST after a restart. The POST was to " + req.getResourceRef().getPath(), Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }

    private String makeFormPage(TileLayer tl) {
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        this.makeTaskList(doc, tl);
        this.makeWarningsAndHints(doc, tl);
        this.makeFormHeader(doc, tl);
        this.makeThreadCountPullDown(doc);
        this.makeTypePullDown(doc);
        this.makeSRSPulldown(doc, tl);
        this.makeFormatPullDown(doc, tl);
        this.makeZoomStartPullDown(doc, tl);
        this.makeZoomStopPullDown(doc, tl);
        this.makeBboxFields(doc);
        this.makeSubmit(doc);
        this.makeFormFooter(doc);
        this.makeFooter(doc);
        return doc.toString();
    }

    private String makeResponsePage(TileLayer tl) {
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        doc.append("<h3>Task submitted</h3>\n");
        doc.append("<p>Below you can find a list of currently executing threads, take the numbers with a grain of salt");
        doc.append(" until the thread has had a chance to run for a few minutes. ");
        this.makeTaskList(doc, tl);
        this.makeFooter(doc);
        return doc.toString();
    }

    private void makeTypePullDown(StringBuilder doc) {
        doc.append("<tr><td>Type of operation:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        keysValues.put("Truncate - remove tiles", "truncate");
        keysValues.put("Seed - generate missing tiles", "seed");
        keysValues.put("Reseed - regenerate all tiles", "reseed");
        this.makePullDown(doc, "type", keysValues, "seed");
        doc.append("</td></tr>\n");
    }

    private void makeThreadCountPullDown(StringBuilder doc) {
        doc.append("<tr><td>Number of threads to use:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        for (int i = 1; i < 17; ++i) {
            if (i < 10) {
                keysValues.put("0" + Integer.toString(i), "0" + Integer.toString(i));
                continue;
            }
            keysValues.put(Integer.toString(i), Integer.toString(i));
        }
        this.makePullDown(doc, "threadCount", keysValues, Integer.toString(2));
        doc.append("</td></tr>\n");
    }

    private void makeBboxFields(StringBuilder doc) {
        doc.append("<tr><td valign=\"top\">Bounding box:</td><td>\n");
        this.makeTextInput(doc, "minX", 6);
        this.makeTextInput(doc, "minY", 6);
        this.makeTextInput(doc, "maxX", 6);
        this.makeTextInput(doc, "maxY", 6);
        doc.append("</br>These are optional, approximate values are fine.");
        doc.append("</td></tr>\n");
    }

    private void makeBboxHints(StringBuilder doc, TileLayer tl) {
        for (Map.Entry<SRS, Grid> entry : tl.getGrids().entrySet()) {
            doc.append("<li>" + entry.getKey().toString() + ":   " + entry.getValue().getBounds().toString() + "</li>\n");
        }
    }

    private void makeTextInput(StringBuilder doc, String id, int size) {
        doc.append("<input name=\"" + id + "\" type=\"text\" size=\"" + size + "\" />\n");
    }

    private void makeSubmit(StringBuilder doc) {
        doc.append("<tr><td></td><td><input type=\"submit\" value=\"Submit\"></td></tr>\n");
    }

    private void makeZoomStopPullDown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Zoom stop:</td><td>\n");
        this.makeZoomPullDown(doc, false, tl);
        doc.append("</td></tr>\n");
    }

    private void makeZoomStartPullDown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Zoom start:</td><td>\n");
        this.makeZoomPullDown(doc, true, tl);
        doc.append("</td></tr>\n");
    }

    private void makeZoomPullDown(StringBuilder doc, boolean isStart, TileLayer tl) {
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        Iterator<Map.Entry<SRS, Grid>> iter = tl.getGrids().entrySet().iterator();
        int minStart = Integer.MAX_VALUE;
        int maxStop = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            Map.Entry<SRS, Grid> entry = iter.next();
            try {
                entry.getValue().getGridCalculator();
            }
            catch (GeoWebCacheException e) {
                e.printStackTrace();
            }
            int start = entry.getValue().getZoomStart();
            int stop = entry.getValue().getZoomStop();
            if (start < minStart) {
                minStart = start;
            }
            if (stop <= maxStop) continue;
            maxStop = stop;
        }
        for (int i = minStart; i <= maxStop; ++i) {
            if (i < 10) {
                keysValues.put("0" + Integer.toString(i), "0" + Integer.toString(i));
                continue;
            }
            keysValues.put(Integer.toString(i), Integer.toString(i));
        }
        if (isStart) {
            if (minStart < 10) {
                this.makePullDown(doc, "zoomStart", keysValues, "0" + Integer.toString(minStart));
            } else {
                this.makePullDown(doc, "zoomStart", keysValues, Integer.toString(minStart));
            }
        } else {
            int midStop = (minStart + maxStop) / 2;
            if (midStop < 10) {
                this.makePullDown(doc, "zoomStop", keysValues, "0" + Integer.toString(midStop));
            } else {
                this.makePullDown(doc, "zoomStop", keysValues, Integer.toString(midStop));
            }
        }
    }

    private void makeFormatPullDown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>Format:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        for (MimeType mime : tl.getMimeTypes()) {
            keysValues.put(mime.getFormat(), mime.getFormat());
        }
        this.makePullDown(doc, "format", keysValues, ImageMime.png.getFormat());
        doc.append("</td></tr>\n");
    }

    private void makeSRSPulldown(StringBuilder doc, TileLayer tl) {
        doc.append("<tr><td>SRS:</td><td>\n");
        TreeMap<String, String> keysValues = new TreeMap<String, String>();
        for (Map.Entry<SRS, Grid> entry : tl.getGrids().entrySet()) {
            keysValues.put(entry.getKey().toString(), Integer.toString(entry.getKey().getNumber()));
        }
        this.makePullDown(doc, "srs", keysValues, SRS.getEPSG4326().toString());
        doc.append("</td></tr>\n");
    }

    private void makePullDown(StringBuilder doc, String id, Map<String, String> keysValues, String defaultKey) {
        doc.append("<select name=\"" + id + "\">\n");
        for (Map.Entry<String, String> entry : keysValues.entrySet()) {
            if (entry.getKey().equals(defaultKey)) {
                doc.append("<option value=\"" + entry.getValue() + "\" selected=\"selected\">" + entry.getKey() + "</option>\n");
                continue;
            }
            doc.append("<option value=\"" + entry.getValue() + "\">" + entry.getKey() + "</option>\n");
        }
        doc.append("</select>\n");
    }

    private void makeFormHeader(StringBuilder doc, TileLayer tl) {
        doc.append("<h4>Create a new task:</h4>\n");
        doc.append("<form id=\"seed\" action=\"./" + tl.getName() + "\" method=\"post\">\n");
        doc.append("<table border=\"0\" cellspacing=\"10\">\n");
    }

    private void makeFormFooter(StringBuilder doc) {
        doc.append("</table>\n");
        doc.append("</form>\n");
    }

    private void makeHeader(StringBuilder doc) {
        doc.append("<html><body>\n<a id=\"logo\" href=\"http://geowebcache.org\"><img src=\"http://geowebcache.org/trac/chrome/site/geowebcache_logo.png\"height=\"100\" width=\"353\" border=\"0\"/></a>\n");
    }

    private void makeWarningsAndHints(StringBuilder doc, TileLayer tl) {
        doc.append("<h4>Please note:</h4><ul>\n<li>This minimalistic interface does not check for correctness.</li>\n<li>Seeding past zoomlevel 20 is usually not recommended.</li>\n<li>Truncating KML will also truncate all KMZ archives.</li>\n<li>Please check the logs of the container to look for error messages and progress indicators.</li>\n</ul>\n");
        doc.append("Here are the max bounds, if you do not specify bounds these will be used.\n");
        doc.append("<ul>\n");
        this.makeBboxHints(doc, tl);
        doc.append("</ul>\n");
    }

    private void makeTaskList(StringBuilder doc, TileLayer tl) {
        doc.append("<h4>List of currently executing tasks:</h4>\n");
        Iterator<Map.Entry<Long, GWCTask>> iter = this.threadPool.getRunningTasksIterator();
        boolean tasks = false;
        if (!iter.hasNext()) {
            doc.append("<ul><li><i>none</i></li></ul>\n");
        } else {
            doc.append("<table border=\"0\" cellspacing=\"10\">");
            doc.append("<tr style=\"font-weight: bold;\"><td>Id</td><td>Layer</td><td>Type</td><td>Tiles total</td><td>Tiles completed</td><td>Time remaining</td><td>Threads</td><td>&nbsp;</td><tr>");
            tasks = true;
        }
        while (iter.hasNext()) {
            Map.Entry<Long, GWCTask> entry = iter.next();
            GWCTask task = entry.getValue();
            int time = task.getTimeRemaining();
            String timeRemaining = task.getTilesDone() < 50L ? " Estimating..." : (time > 86400 ? "" + time / 86400 + " day(s)" : (time > 3600 ? "" + time / 3600 + " hour(s)" : (time > 60 ? "" + time / 60 + " minute(s)" : "" + time + " second(s)")));
            doc.append("<tr><td>" + entry.getKey() + "</td>" + "<td>" + task.getLayerName() + "</td>" + "<td>" + task.getType() + "</td>" + "<td>" + task.getTilesTotal() + "</td>" + "<td>" + task.getTilesDone() + "</td>" + "<td>" + timeRemaining + "</td>" + "<td>(Thread " + (task.getThreadOffset() + 1) + " of " + task.getThreadCount() + ") </td>" + "<td>" + this.makeThreadKillForm(entry.getKey(), tl) + "</td><tr>");
        }
        if (tasks) {
            doc.append("</table>");
        }
        doc.append("<p><a href=\"./" + tl.getName() + "\">Refresh list</a></p>\n");
    }

    private String makeThreadKillForm(Long key, TileLayer tl) {
        String ret = "<form form id=\"kill\" action=\"./" + tl.getName() + "\" method=\"post\">" + "<input type=\"hidden\" name=\"kill_thread\"  value=\"1\" />" + "<input type=\"hidden\" name=\"thread_id\"  value=\"" + key + "\" />" + "<span><input style=\"padding: 0; margin-bottom: -12px; border: 1;\"type=\"submit\" value=\"Kill Thread\"></span>" + "</form>";
        return ret;
    }

    private void makeFooter(StringBuilder doc) {
        doc.append("</body></html>\n");
    }

    private void handleKillThreadPost(Form form, TileLayer tl, Response resp) {
        String id = form.getFirstValue("thread_id");
        StringBuilder doc = new StringBuilder();
        this.makeHeader(doc);
        if (this.threadPool.terminateGWCTask(Long.parseLong(id))) {
            doc.append("<ul><li>Requested to terminate task " + id + ".</li></ul>");
        } else {
            doc.append("<ul><li>Sorry, either task " + id + " has not started yet, or it is a truncate task that cannot be interrutped.</li></ul>");
        }
        doc.append("<p><a href=\"./" + tl.getName() + "\">Go back</a></p>\n");
        resp.setEntity(doc.toString(), MediaType.TEXT_HTML);
    }

    private void handleDoSeedPost(Form form, TileLayer tl, Response resp) throws RestletException {
        BBOX bounds = null;
        if (form.getFirst("minX").getValue() != null) {
            bounds = new BBOX(SeedFormRestlet.parseDouble(form, "minX"), SeedFormRestlet.parseDouble(form, "minY"), SeedFormRestlet.parseDouble(form, "maxX"), SeedFormRestlet.parseDouble(form, "maxY"));
        }
        SRS srs = SRS.getSRS(Integer.parseInt(form.getFirst("srs").getValue()));
        int threadCount = Integer.parseInt(form.getFirst("threadCount").getValue());
        int zoomStart = Integer.parseInt(form.getFirst("zoomStart").getValue());
        int zoomStop = Integer.parseInt(form.getFirst("zoomStop").getValue());
        String format = form.getFirst("format").getValue();
        String type = form.getFirst("type").getValue();
        SeedRequest sr = new SeedRequest(tl.getName(), bounds, srs, threadCount, zoomStart, zoomStop, format, type);
        this.seedRestlet.dispatchTasks(sr, tl, this.threadPool);
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        resp.setEntity(this.makeResponsePage(tl), MediaType.TEXT_HTML);
    }

    private static double parseDouble(Form form, String key) throws RestletException {
        String value = form.getFirst(key).getValue();
        if (value == null || value.length() == 0) {
            throw new RestletException("Missing value for " + key, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new RestletException("Value for " + key + " is not a double", Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setThreadPoolExecutor(SeederThreadPoolExecutor stpe) {
        this.threadPool = stpe;
    }

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }

    public void setSeedRestlet(SeedRestlet sr) {
        this.seedRestlet = sr;
    }
}

