/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.seed;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.GWCRestlet;
import org.geowebcache.rest.GWCTask;
import org.geowebcache.rest.RestletException;
import org.geowebcache.rest.seed.MTSeeder;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.rest.seed.SeedTask;
import org.geowebcache.rest.seed.SeederThreadPoolExecutor;
import org.geowebcache.rest.seed.TruncateTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.XMLConfiguration;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;

public class SeedRestlet
extends GWCRestlet {
    SeederThreadPoolExecutor threadPool;
    TileLayerDispatcher layerDispatcher;
    StorageBroker storageBroker;
    public JSONObject myrequest;
    private static Log log = LogFactory.getLog(SeedRestlet.class);

    public void handle(Request request, Response response) {
        block5: {
            Method met = request.getMethod();
            try {
                if (met.equals((Object)Method.GET)) {
                    this.doGet(request, response);
                    break block5;
                }
                if (met.equals((Object)Method.POST)) {
                    this.doPost(request, response);
                    break block5;
                }
                throw new RestletException("Method not allowed", Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
            catch (RestletException re) {
                response.setEntity(re.getRepresentation());
                response.setStatus(re.getStatus());
            }
            catch (IOException ioe) {
                response.setEntity("Encountered IO error " + ioe.getMessage(), MediaType.TEXT_PLAIN);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(Request req, Response resp) throws RestletException {
        JsonRepresentation rep = null;
        try {
            int[][] list;
            XStream xs = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            JSONObject obj = null;
            int[][] nArray = list = this.getStatusList();
            synchronized (list) {
                obj = new JSONObject(xs.toXML((Object)list));
                // ** MonitorExit[var7_8] (shouldn't be in output)
                rep = new JsonRepresentation(obj);
            }
        }
        catch (JSONException jse) {
            jse.printStackTrace();
        }
        {
            resp.setEntity(rep);
            return;
        }
    }

    public void doPost(Request req, Response resp) throws RestletException, IOException {
        String formatExtension = (String)req.getAttributes().get("extension");
        SeedRequest sr = null;
        XStream xs = XMLConfiguration.getConfiguredXStream(new XStream((HierarchicalStreamDriver)new DomDriver()));
        if (formatExtension.equalsIgnoreCase("xml")) {
            sr = (SeedRequest)xs.fromXML(req.getEntity().getStream());
        } else if (formatExtension.equalsIgnoreCase("json")) {
            sr = (SeedRequest)xs.fromXML(this.convertJson(req.getEntity().getText()));
        } else {
            throw new RestletException("Format extension unknown or not specified: " + formatExtension, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        String layerName = null;
        try {
            layerName = URLDecoder.decode((String)req.getAttributes().get("layer"), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        TileLayer tl = SeedRestlet.findTileLayer(layerName, this.layerDispatcher);
        this.dispatchTasks(sr, tl, this.threadPool);
    }

    private String convertJson(String entityText) throws IOException {
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        StringReader reader = new StringReader(entityText);
        HierarchicalStreamReader hsr = driver.createReader((Reader)reader);
        StringWriter writer = new StringWriter();
        new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
        writer.close();
        return writer.toString();
    }

    void dispatchTasks(SeedRequest sr, TileLayer tl, ThreadPoolExecutor threadPoolExec) throws RestletException {
        int threadCount;
        String type;
        if (sr.getType() == null || sr.getType().length() == 0) {
            type = "seed";
        } else {
            type = sr.getType();
            if (!(type.equalsIgnoreCase("seed") || type.equalsIgnoreCase("reseed") || type.equalsIgnoreCase("truncate"))) {
                throw new RestletException("Unknown request type " + sr.getType(), Status.CLIENT_ERROR_BAD_REQUEST);
            }
        }
        if (null == sr.getThreadCount() || sr.getThreadCount() < 1 || type.equalsIgnoreCase("truncate")) {
            threadCount = 1;
        } else {
            threadCount = sr.getThreadCount();
            if (threadCount > threadPoolExec.getMaximumPoolSize()) {
                throw new RestletException("Asked to use " + threadCount + " threads," + " but maximum is " + threadPoolExec.getMaximumPoolSize(), Status.SERVER_ERROR_INTERNAL);
            }
        }
        if (threadCount > 1) {
            for (int i = 0; i < threadCount; ++i) {
                GWCTask task = this.createTask(type, sr, tl);
                task.setThreadInfo(threadCount, i);
                threadPoolExec.submit(new MTSeeder(task));
            }
        } else {
            GWCTask task = this.createTask(type, sr, tl);
            threadPoolExec.submit(new MTSeeder(task));
        }
    }

    private GWCTask createTask(String type, SeedRequest rq, TileLayer tl) {
        if (type.equalsIgnoreCase("seed")) {
            return new SeedTask(this.storageBroker, rq, tl, false);
        }
        if (type.equalsIgnoreCase("reseed")) {
            return new SeedTask(this.storageBroker, rq, tl, true);
        }
        if (type.equalsIgnoreCase("truncate")) {
            return new TruncateTask(this.storageBroker, rq, tl);
        }
        return null;
    }

    private int[][] getStatusList() {
        Iterator<Map.Entry<Long, GWCTask>> iter = this.threadPool.getRunningTasksIterator();
        int[][] ret = new int[this.threadPool.getMaximumPoolSize()][3];
        int idx = 0;
        while (iter.hasNext()) {
            Map.Entry<Long, GWCTask> entry = iter.next();
            GWCTask task = entry.getValue();
            ret[idx][0] = (int)task.getTilesDone();
            ret[idx][1] = (int)task.getTilesTotal();
            ret[idx][2] = task.getTimeRemaining();
        }
        return ret;
    }

    public void setTileLayerDispatcher(TileLayerDispatcher tileLayerDispatcher) {
        this.layerDispatcher = tileLayerDispatcher;
    }

    public void setThreadPoolExecutor(SeederThreadPoolExecutor stpe) {
        this.threadPool = stpe;
    }

    public void setStorageBroker(StorageBroker sb) {
        this.storageBroker = sb;
    }
}

