/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.WFSObject;

public class StorageBroker {
    private static Log log = LogFactory.getLog(StorageBroker.class);
    private BlobStore blobStore;
    private MetaStore metaStore;

    public StorageBroker(MetaStore metaStore, BlobStore blobStore) {
        this.metaStore = metaStore;
        this.blobStore = blobStore;
    }

    public boolean get(TileObject tileObj) throws StorageException {
        if (!this.metaStore.get(tileObj)) {
            return false;
        }
        if (tileObj.getId() == -1L) {
            throw new StorageException("metaStore.get() returned true, but did not set an id on the object");
        }
        if (tileObj.blob_size > 0) {
            byte[] blob = this.blobStore.get(tileObj);
            if (blob == null) {
                throw new StorageException("Blob was expected to have size " + tileObj.blob_size + " but was null.");
            }
            if (blob.length != tileObj.blob_size) {
                throw new StorageException("Blob was expected to have size " + tileObj.blob_size + " but was " + blob.length);
            }
            tileObj.blob = blob;
        }
        return true;
    }

    public boolean get(WFSObject wfsObj) throws StorageException {
        if (!this.metaStore.get(wfsObj)) {
            return false;
        }
        if (wfsObj.getId() == -1L) {
            throw new StorageException("metaStore.get() returned true, but did not set an id on the object");
        }
        if (this.blobStore.get(wfsObj) == 0L) {
            throw new StorageException("The blob for WFS " + Long.toString(wfsObj.getId()) + " was of size 0");
        }
        return true;
    }

    public boolean put(TileObject tileObj) {
        try {
            this.metaStore.put(tileObj);
            this.blobStore.put(tileObj);
            return true;
        }
        catch (StorageException se) {
            log.error((Object)se.getMessage());
            return false;
        }
    }

    public boolean put(WFSObject wfsObj) {
        try {
            this.metaStore.put(wfsObj);
            this.blobStore.put(wfsObj);
            return true;
        }
        catch (StorageException se) {
            log.error((Object)se.getMessage());
            return false;
        }
    }
}

