/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.WFSObject;

class JDBCMBWrapper {
    private static Log log = LogFactory.getLog(JDBCMBWrapper.class);
    static int DB_VERSION = 110;
    final String jdbcString;
    final String username;
    final String password;
    final String driverClass;

    protected JDBCMBWrapper(String driverClass, String jdbcString, String username, String password) throws StorageException, SQLException {
        this.jdbcString = jdbcString;
        this.username = username;
        this.password = password;
        this.driverClass = driverClass;
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StorageException("Class not found: " + cnfe.getMessage());
        }
        this.checkTables();
    }

    public JDBCMBWrapper(DefaultStorageFinder defStoreFind) throws StorageException, SQLException {
        this.username = "sa";
        this.password = "";
        this.driverClass = "org.h2.Driver";
        String path = defStoreFind.getDefaultPath() + File.separator + "meta_jdbc_h2";
        File dir = new File(path);
        dir.mkdirs();
        this.jdbcString = "jdbc:h2:file:" + path + File.separator + "gwc_metastore";
        try {
            Class.forName(this.driverClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new StorageException("Class not found: " + cnfe.getMessage());
        }
        this.checkTables();
    }

    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcString, this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTables() throws StorageException, SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.checkVariableTable(conn);
            this.condCreate(conn, "LAYERS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(254) UNIQUE", "VALUE", null);
            this.condCreate(conn, "PARAMETERS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(254) UNIQUE", "VALUE", null);
            this.condCreate(conn, "FORMATS", "ID BIGINT AUTO_INCREMENT PRIMARY KEY, VALUE VARCHAR(126) UNIQUE", "VALUE", null);
            this.checkWFSTable(conn);
            this.checkTilesTable(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVariableTable(Connection conn) throws SQLException, StorageException {
        this.condCreate(conn, "VARIABLES", "KEY VARCHAR(32), VALUE VARCHAR(128)", "KEY", null);
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("SELECT VALUE FROM VARIABLES WHERE KEY LIKE 'db_version'");
            if (rs.first()) {
                String db_versionStr = rs.getString("value");
                int cur_db_version = Integer.parseInt(db_versionStr);
                if (cur_db_version > DB_VERSION) {
                    throw new StorageException("The H2 database was created by a newer version of the software.");
                }
                if (cur_db_version < DB_VERSION) {
                    this.runDbUpgrade(conn, cur_db_version);
                }
            } else {
                st.execute("INSERT INTO VARIABLES (KEY,VALUE)  VALUES ('db_version'," + DB_VERSION + ")");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    private void checkWFSTable(Connection conn) throws SQLException {
        this.condCreate(conn, "WFS", "WFS_ID BIGINT AUTO_INCREMENT PRIMARY KEY, PARAMETERS_ID BIGINT, QUERY_BLOB_MD5 VARCHAR(32), QUERY_BLOB_SIZE INT, BLOB_SIZE INT, CREATED BIGINT, ACCESS_LAST BIGINT, ACCESS_COUNT BIGINT", "PARAMETERS_ID", "QUERY_BLOB_MD5, QUERY_BLOB_SIZE");
    }

    private void checkTilesTable(Connection conn) throws SQLException {
        this.condCreate(conn, "TILES", "TILE_ID BIGINT AUTO_INCREMENT PRIMARY KEY, LAYER_ID BIGINT, X BIGINT, Y BIGINT, Z BIGINT, SRS_ID INT, FORMAT_ID BIGINT, PARAMETERS_ID BIGINT, BLOB_SIZE INT, CREATED BIGINT, ACCESS_LAST BIGINT, ACCESS_COUNT BIGINT", "LAYER_ID, X, Y, Z, SRS_ID, FORMAT_ID, PARAMETERS_ID", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void condCreate(Connection conn, String tableName, String columns, String indexColumns, String index2Columns) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute("CREATE TABLE IF NOT EXISTS " + tableName + " (" + columns + ")");
            st.execute("CREATE INDEX IF NOT EXISTS IDX_" + tableName + " ON " + tableName + " (" + indexColumns + ")");
            if (index2Columns != null) {
                st.execute("CREATE INDEX IF NOT EXISTS IDX2_" + tableName + " ON " + tableName + " (" + index2Columns + ")");
            }
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    private void runDbUpgrade(Connection conn, int fromVersion) {
        log.info((Object)("Upgrading  H2 database from " + fromVersion + " to " + DB_VERSION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getTile(TileObject stObj) throws SQLException {
        String query = stObj.getParametersId() == -1L ? "SELECT TILE_ID,BLOB_SIZE,CREATED FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND SRS_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID IS NULL LIMIT 1 " : "SELECT TILE_ID,BLOB_SIZE,CREATED FROM TILES WHERE  LAYER_ID = ? AND X = ? AND Y = ? AND Z = ? AND SRS_ID = ?  AND FORMAT_ID = ? AND PARAMETERS_ID = ? LIMIT 1 ";
        long[] xyz = stObj.getXYZ();
        PreparedStatement prep = this.getConnection().prepareStatement(query);
        prep.setLong(1, stObj.getLayerId());
        prep.setLong(2, xyz[0]);
        prep.setLong(3, xyz[1]);
        prep.setLong(4, xyz[2]);
        prep.setLong(5, stObj.getSrs());
        prep.setLong(6, stObj.getFormatId());
        if (stObj.getParametersId() != -1L) {
            prep.setLong(7, stObj.getParametersId());
        }
        ResultSet rs = null;
        try {
            rs = prep.executeQuery();
            if (rs.first()) {
                stObj.setId(rs.getLong(1));
                stObj.setBlobSize(rs.getInt(2));
                stObj.setCreated(rs.getLong(3));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (prep != null) {
                prep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getWFS(Long parameters, WFSObject wfsObj) throws SQLException {
        String query = null;
        PreparedStatement prep = null;
        if (parameters != null) {
            query = "SELECT WFS_ID,BLOB_SIZE,CREATED FROM WFS WHERE  PARAMETERS_ID = ? LIMIT 1 ";
            prep = this.getConnection().prepareStatement(query);
            prep.setLong(1, parameters);
        } else {
            query = "SELECT WFS_ID,BLOB_SIZE,CREATED FROM WFS WHERE  QUERY_BLOB_MD5 LIKE ? AND QUERY_BLOB_SIZE = ? LIMIT 1";
            prep = this.getConnection().prepareStatement(query);
            prep.setString(1, wfsObj.getQueryBlobMd5());
            prep.setInt(2, wfsObj.getQueryBlobSize());
        }
        ResultSet rs = null;
        try {
            rs = prep.executeQuery();
            if (rs.next()) {
                wfsObj.setId(rs.getLong(1));
                wfsObj.setBlobSize(rs.getInt(2));
                wfsObj.setCreated(rs.getLong(3));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (prep != null) {
                prep.close();
            }
        }
    }

    public void putTile(TileObject stObj) throws SQLException, StorageException {
        String query = "INSERT INTO TILES (  LAYER_ID,X,Y,Z,SRS_ID,FORMAT_ID,PARAMETERS_ID,BLOB_SIZE) VALUES(?,?,?,?,?,?,?,?)";
        long[] xyz = stObj.getXYZ();
        PreparedStatement prep = this.getConnection().prepareStatement(query, 1);
        prep.setLong(1, stObj.getLayerId());
        prep.setLong(2, xyz[0]);
        prep.setLong(3, xyz[1]);
        prep.setLong(4, xyz[2]);
        prep.setLong(5, stObj.getSrs());
        prep.setLong(6, stObj.getFormatId());
        if (stObj.getParametersId() == -1L) {
            prep.setNull(7, -5);
        } else {
            prep.setLong(7, stObj.getParametersId());
        }
        prep.setInt(8, stObj.getBlobSize());
        Long insertId = this.wrappedInsert(prep);
        if (insertId == null) {
            log.error((Object)("Did not receive a id for " + query));
        } else {
            stObj.setId(insertId);
        }
    }

    public void putWFS(Long parameters, WFSObject stObj) throws SQLException, StorageException {
        PreparedStatement prep = null;
        String query = null;
        if (parameters != null) {
            query = "INSERT INTO WFS (  PARAMETERS_ID,BLOB_SIZE,CREATED) VALUES(?,?,?)";
            prep = this.getConnection().prepareStatement(query, 1);
            prep.setLong(1, parameters);
            prep.setInt(2, stObj.getBlobSize());
            prep.setLong(3, stObj.getCreated());
        } else {
            query = "INSERT INTO WFS ( QUERY_BLOB_MD5, QUERY_BLOB_SIZE,BLOB_SIZE,CREATED) VALUES(?,?,?,?)";
            prep = this.getConnection().prepareStatement(query, 1);
            prep.setString(1, stObj.getQueryBlobMd5());
            prep.setInt(2, stObj.getQueryBlobSize());
            prep.setInt(3, stObj.getBlobSize());
            prep.setLong(4, stObj.getCreated());
        }
        Long insertId = this.wrappedInsert(prep);
        if (insertId == null) {
            log.error((Object)("Did not receive a id for " + query));
        } else {
            stObj.setId(insertId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long wrappedInsert(PreparedStatement st) throws SQLException {
        ResultSet rs = null;
        try {
            st.executeUpdate();
            rs = st.getGeneratedKeys();
            if (rs.next()) {
                Long l = rs.getLong(1);
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }
}

